/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordRefCharcField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChangeRecordRefCharcSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Characteristic Assignments to Change Records
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeRecordRefCharcType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeRecordRefCharc extends VdmEntity<ChangeRecordRefCharc>
{

    /**
     * Selector for all available fields of ChangeRecordRefCharc.
     *
     */
    public final static ChangeRecordRefCharcSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<Boolean> DELETE_MC =
        new ChangeRecordRefCharcField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<Boolean> UPDATE_MC =
        new ChangeRecordRefCharcField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChangeRecordReferenceUUID" )
    @JsonProperty( "ChangeRecordReferenceUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceUUID" )
    private UUID changeRecordReferenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<UUID> CHANGE_RECORD_REFERENCE_UUID =
        new ChangeRecordRefCharcField<UUID>("ChangeRecordReferenceUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @return Issue ID
     */
    @SerializedName( "ChangeRecord" )
    @JsonProperty( "ChangeRecord" )
    @Nullable
    @ODataField( odataName = "ChangeRecord" )
    private String changeRecord;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecord</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_RECORD =
        new ChangeRecordRefCharcField<String>("ChangeRecord");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHARACTERISTIC =
        new ChangeRecordRefCharcField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_NUMBER =
        new ChangeRecordRefCharcField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @return Data type of characteristic
     */
    @SerializedName( "CharcDataType" )
    @JsonProperty( "CharcDataType" )
    @Nullable
    @ODataField( odataName = "CharcDataType" )
    private String charcDataType;
    /**
     * Use with available fluent helpers to apply the <b>CharcDataType</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHARC_DATA_TYPE =
        new ChangeRecordRefCharcField<String>("CharcDataType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcStatus</b>
     * </p>
     *
     * @return Status of a characteristic
     */
    @SerializedName( "CharcStatus" )
    @JsonProperty( "CharcStatus" )
    @Nullable
    @ODataField( odataName = "CharcStatus" )
    private String charcStatus;
    /**
     * Use with available fluent helpers to apply the <b>CharcStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHARC_STATUS =
        new ChangeRecordRefCharcField<String>("CharcStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<LocalDateTime> VALIDITY_START_DATE =
        new ChangeRecordRefCharcField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHARC_INTERNAL_ID =
        new ChangeRecordRefCharcField<String>("CharcInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimals</b>
     * </p>
     *
     * @return Number of Decimal Places
     */
    @SerializedName( "CharcDecimals" )
    @JsonProperty( "CharcDecimals" )
    @Nullable
    @ODataField( odataName = "CharcDecimals" )
    private Short charcDecimals;
    /**
     * Use with available fluent helpers to apply the <b>CharcDecimals</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<Short> CHARC_DECIMALS =
        new ChangeRecordRefCharcField<Short>("CharcDecimals");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcLength</b>
     * </p>
     *
     * @return Number of Characters
     */
    @SerializedName( "CharcLength" )
    @JsonProperty( "CharcLength" )
    @Nullable
    @ODataField( odataName = "CharcLength" )
    private Short charcLength;
    /**
     * Use with available fluent helpers to apply the <b>CharcLength</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<Short> CHARC_LENGTH =
        new ChangeRecordRefCharcField<Short>("CharcLength");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcValueUnit" )
    @JsonProperty( "CharcValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcValueUnit" )
    private String charcValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueUnit</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHARC_VALUE_UNIT =
        new ChangeRecordRefCharcField<String>("CharcValueUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "ChangeRecordUUID" )
    @JsonProperty( "ChangeRecordUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordUUID" )
    private UUID changeRecordUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<UUID> CHANGE_RECORD_UUID =
        new ChangeRecordRefCharcField<UUID>("ChangeRecordUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @return Object Type
     */
    @SerializedName( "ChangeRecordReferenceType" )
    @JsonProperty( "ChangeRecordReferenceType" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceType" )
    private String changeRecordReferenceType;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceType</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_RECORD_REFERENCE_TYPE =
        new ChangeRecordRefCharcField<String>("ChangeRecordReferenceType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceSubtype</b>
     * </p>
     *
     * @return Object Subtype
     */
    @SerializedName( "ChangeRecordReferenceSubtype" )
    @JsonProperty( "ChangeRecordReferenceSubtype" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceSubtype" )
    private String changeRecordReferenceSubtype;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceSubtype</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_RECORD_REFERENCE_SUBTYPE =
        new ChangeRecordRefCharcField<String>("ChangeRecordReferenceSubtype");
    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReference</b>
     * </p>
     *
     * @return Reference Object ID
     */
    @SerializedName( "ChangeRecordReference" )
    @JsonProperty( "ChangeRecordReference" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReference" )
    private String changeRecordReference;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReference</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_RECORD_REFERENCE =
        new ChangeRecordRefCharcField<String>("ChangeRecordReference");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentChangeRecordRefUUID</b>
     * </p>
     *
     * @return Business Object Node ID
     */
    @SerializedName( "ParentChangeRecordRefUUID" )
    @JsonProperty( "ParentChangeRecordRefUUID" )
    @Nullable
    @ODataField( odataName = "ParentChangeRecordRefUUID" )
    private UUID parentChangeRecordRefUUID;
    /**
     * Use with available fluent helpers to apply the <b>ParentChangeRecordRefUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<UUID> PARENT_CHANGE_RECORD_REF_UUID =
        new ChangeRecordRefCharcField<UUID>("ParentChangeRecordRefUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMainReference</b>
     * </p>
     *
     * @return Main Reference
     */
    @SerializedName( "IsMainReference" )
    @JsonProperty( "IsMainReference" )
    @Nullable
    @ODataField( odataName = "IsMainReference" )
    private String isMainReference;
    /**
     * Use with available fluent helpers to apply the <b>IsMainReference</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> IS_MAIN_REFERENCE =
        new ChangeRecordRefCharcField<String>("IsMainReference");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CREATED_BY_USER =
        new ChangeRecordRefCharcField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<ZonedDateTime> CREATION_DATE_TIME =
        new ChangeRecordRefCharcField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date of Creation
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<LocalDateTime> CREATION_DATE =
        new ChangeRecordRefCharcField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> LAST_CHANGED_BY_USER =
        new ChangeRecordRefCharcField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ChangeRecordRefCharcField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date on Which Last Change Was Made
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<LocalDateTime> LAST_CHANGE_DATE =
        new ChangeRecordRefCharcField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @return Change Record Item Relevance
     */
    @SerializedName( "ChangeRecordItemRelevance" )
    @JsonProperty( "ChangeRecordItemRelevance" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemRelevance" )
    private String changeRecordItemRelevance;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemRelevance</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_RECORD_ITEM_RELEVANCE =
        new ChangeRecordRefCharcField<String>("ChangeRecordItemRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordVirtualRefInd</b>
     * </p>
     *
     * @return Virtual object indicated in Change Record
     */
    @SerializedName( "ChangeRecordVirtualRefInd" )
    @JsonProperty( "ChangeRecordVirtualRefInd" )
    @Nullable
    @ODataField( odataName = "ChangeRecordVirtualRefInd" )
    private String changeRecordVirtualRefInd;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordVirtualRefInd</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_RECORD_VIRTUAL_REF_IND =
        new ChangeRecordRefCharcField<String>("ChangeRecordVirtualRefInd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordRefObjectUUID</b>
     * </p>
     *
     * @return Internal Key of type GUID
     */
    @SerializedName( "ChangeRecordRefObjectUUID" )
    @JsonProperty( "ChangeRecordRefObjectUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordRefObjectUUID" )
    private UUID changeRecordRefObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordRefObjectUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<UUID> CHANGE_RECORD_REF_OBJECT_UUID =
        new ChangeRecordRefCharcField<UUID>("ChangeRecordRefObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @return Item Processing Status
     */
    @SerializedName( "ChangeRecordItemProcgStatus" )
    @JsonProperty( "ChangeRecordItemProcgStatus" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemProcgStatus" )
    private String changeRecordItemProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemProcgStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordRefCharcField<String> CHANGE_RECORD_ITEM_PROCG_STATUS =
        new ChangeRecordRefCharcField<String>("ChangeRecordItemProcgStatus");

    @Nonnull
    @Override
    public Class<ChangeRecordRefCharc> getType()
    {
        return ChangeRecordRefCharc.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     */
    public void setChangeRecordReferenceUUID( @Nullable final UUID changeRecordReferenceUUID )
    {
        rememberChangedField("ChangeRecordReferenceUUID", this.changeRecordReferenceUUID);
        this.changeRecordReferenceUUID = changeRecordReferenceUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @param changeRecord
     *            Issue ID
     */
    public void setChangeRecord( @Nullable final String changeRecord )
    {
        rememberChangedField("ChangeRecord", this.changeRecord);
        this.changeRecord = changeRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @param charcDataType
     *            Data type of characteristic
     */
    public void setCharcDataType( @Nullable final String charcDataType )
    {
        rememberChangedField("CharcDataType", this.charcDataType);
        this.charcDataType = charcDataType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcStatus</b>
     * </p>
     *
     * @param charcStatus
     *            Status of a characteristic
     */
    public void setCharcStatus( @Nullable final String charcStatus )
    {
        rememberChangedField("CharcStatus", this.charcStatus);
        this.charcStatus = charcStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimals</b>
     * </p>
     *
     * @param charcDecimals
     *            Number of Decimal Places
     */
    public void setCharcDecimals( @Nullable final Short charcDecimals )
    {
        rememberChangedField("CharcDecimals", this.charcDecimals);
        this.charcDecimals = charcDecimals;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcLength</b>
     * </p>
     *
     * @param charcLength
     *            Number of Characters
     */
    public void setCharcLength( @Nullable final Short charcLength )
    {
        rememberChangedField("CharcLength", this.charcLength);
        this.charcLength = charcLength;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     *
     * @param charcValueUnit
     *            Unit of Measurement
     */
    public void setCharcValueUnit( @Nullable final String charcValueUnit )
    {
        rememberChangedField("CharcValueUnit", this.charcValueUnit);
        this.charcValueUnit = charcValueUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @param changeRecordUUID
     *            NodeID
     */
    public void setChangeRecordUUID( @Nullable final UUID changeRecordUUID )
    {
        rememberChangedField("ChangeRecordUUID", this.changeRecordUUID);
        this.changeRecordUUID = changeRecordUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @param changeRecordReferenceType
     *            Object Type
     */
    public void setChangeRecordReferenceType( @Nullable final String changeRecordReferenceType )
    {
        rememberChangedField("ChangeRecordReferenceType", this.changeRecordReferenceType);
        this.changeRecordReferenceType = changeRecordReferenceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceSubtype</b>
     * </p>
     *
     * @param changeRecordReferenceSubtype
     *            Object Subtype
     */
    public void setChangeRecordReferenceSubtype( @Nullable final String changeRecordReferenceSubtype )
    {
        rememberChangedField("ChangeRecordReferenceSubtype", this.changeRecordReferenceSubtype);
        this.changeRecordReferenceSubtype = changeRecordReferenceSubtype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReference</b>
     * </p>
     *
     * @param changeRecordReference
     *            Reference Object ID
     */
    public void setChangeRecordReference( @Nullable final String changeRecordReference )
    {
        rememberChangedField("ChangeRecordReference", this.changeRecordReference);
        this.changeRecordReference = changeRecordReference;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentChangeRecordRefUUID</b>
     * </p>
     *
     * @param parentChangeRecordRefUUID
     *            Business Object Node ID
     */
    public void setParentChangeRecordRefUUID( @Nullable final UUID parentChangeRecordRefUUID )
    {
        rememberChangedField("ParentChangeRecordRefUUID", this.parentChangeRecordRefUUID);
        this.parentChangeRecordRefUUID = parentChangeRecordRefUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMainReference</b>
     * </p>
     *
     * @param isMainReference
     *            Main Reference
     */
    public void setIsMainReference( @Nullable final String isMainReference )
    {
        rememberChangedField("IsMainReference", this.isMainReference);
        this.isMainReference = isMainReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date of Creation
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date on Which Last Change Was Made
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @param changeRecordItemRelevance
     *            Change Record Item Relevance
     */
    public void setChangeRecordItemRelevance( @Nullable final String changeRecordItemRelevance )
    {
        rememberChangedField("ChangeRecordItemRelevance", this.changeRecordItemRelevance);
        this.changeRecordItemRelevance = changeRecordItemRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordVirtualRefInd</b>
     * </p>
     *
     * @param changeRecordVirtualRefInd
     *            Virtual object indicated in Change Record
     */
    public void setChangeRecordVirtualRefInd( @Nullable final String changeRecordVirtualRefInd )
    {
        rememberChangedField("ChangeRecordVirtualRefInd", this.changeRecordVirtualRefInd);
        this.changeRecordVirtualRefInd = changeRecordVirtualRefInd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordRefObjectUUID</b>
     * </p>
     *
     * @param changeRecordRefObjectUUID
     *            Internal Key of type GUID
     */
    public void setChangeRecordRefObjectUUID( @Nullable final UUID changeRecordRefObjectUUID )
    {
        rememberChangedField("ChangeRecordRefObjectUUID", this.changeRecordRefObjectUUID);
        this.changeRecordRefObjectUUID = changeRecordRefObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @param changeRecordItemProcgStatus
     *            Item Processing Status
     */
    public void setChangeRecordItemProcgStatus( @Nullable final String changeRecordItemProcgStatus )
    {
        rememberChangedField("ChangeRecordItemProcgStatus", this.changeRecordItemProcgStatus);
        this.changeRecordItemProcgStatus = changeRecordItemProcgStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeRecordRefCharc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        values.put("ChangeRecord", getChangeRecord());
        values.put("Characteristic", getCharacteristic());
        values.put("ChangeNumber", getChangeNumber());
        values.put("CharcDataType", getCharcDataType());
        values.put("CharcStatus", getCharcStatus());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("CharcDecimals", getCharcDecimals());
        values.put("CharcLength", getCharcLength());
        values.put("CharcValueUnit", getCharcValueUnit());
        values.put("ChangeRecordUUID", getChangeRecordUUID());
        values.put("ChangeRecordReferenceType", getChangeRecordReferenceType());
        values.put("ChangeRecordReferenceSubtype", getChangeRecordReferenceSubtype());
        values.put("ChangeRecordReference", getChangeRecordReference());
        values.put("ParentChangeRecordRefUUID", getParentChangeRecordRefUUID());
        values.put("IsMainReference", getIsMainReference());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ChangeRecordItemRelevance", getChangeRecordItemRelevance());
        values.put("ChangeRecordVirtualRefInd", getChangeRecordVirtualRefInd());
        values.put("ChangeRecordRefObjectUUID", getChangeRecordRefObjectUUID());
        values.put("ChangeRecordItemProcgStatus", getChangeRecordItemProcgStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceUUID") ) {
                final Object value = values.remove("ChangeRecordReferenceUUID");
                if( (value == null) || (!value.equals(getChangeRecordReferenceUUID())) ) {
                    setChangeRecordReferenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecord") ) {
                final Object value = values.remove("ChangeRecord");
                if( (value == null) || (!value.equals(getChangeRecord())) ) {
                    setChangeRecord(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("CharcDataType") ) {
                final Object value = values.remove("CharcDataType");
                if( (value == null) || (!value.equals(getCharcDataType())) ) {
                    setCharcDataType(((String) value));
                }
            }
            if( values.containsKey("CharcStatus") ) {
                final Object value = values.remove("CharcStatus");
                if( (value == null) || (!value.equals(getCharcStatus())) ) {
                    setCharcStatus(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcDecimals") ) {
                final Object value = values.remove("CharcDecimals");
                if( (value == null) || (!value.equals(getCharcDecimals())) ) {
                    setCharcDecimals(((Short) value));
                }
            }
            if( values.containsKey("CharcLength") ) {
                final Object value = values.remove("CharcLength");
                if( (value == null) || (!value.equals(getCharcLength())) ) {
                    setCharcLength(((Short) value));
                }
            }
            if( values.containsKey("CharcValueUnit") ) {
                final Object value = values.remove("CharcValueUnit");
                if( (value == null) || (!value.equals(getCharcValueUnit())) ) {
                    setCharcValueUnit(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordUUID") ) {
                final Object value = values.remove("ChangeRecordUUID");
                if( (value == null) || (!value.equals(getChangeRecordUUID())) ) {
                    setChangeRecordUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceType") ) {
                final Object value = values.remove("ChangeRecordReferenceType");
                if( (value == null) || (!value.equals(getChangeRecordReferenceType())) ) {
                    setChangeRecordReferenceType(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceSubtype") ) {
                final Object value = values.remove("ChangeRecordReferenceSubtype");
                if( (value == null) || (!value.equals(getChangeRecordReferenceSubtype())) ) {
                    setChangeRecordReferenceSubtype(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordReference") ) {
                final Object value = values.remove("ChangeRecordReference");
                if( (value == null) || (!value.equals(getChangeRecordReference())) ) {
                    setChangeRecordReference(((String) value));
                }
            }
            if( values.containsKey("ParentChangeRecordRefUUID") ) {
                final Object value = values.remove("ParentChangeRecordRefUUID");
                if( (value == null) || (!value.equals(getParentChangeRecordRefUUID())) ) {
                    setParentChangeRecordRefUUID(((UUID) value));
                }
            }
            if( values.containsKey("IsMainReference") ) {
                final Object value = values.remove("IsMainReference");
                if( (value == null) || (!value.equals(getIsMainReference())) ) {
                    setIsMainReference(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeRecordItemRelevance") ) {
                final Object value = values.remove("ChangeRecordItemRelevance");
                if( (value == null) || (!value.equals(getChangeRecordItemRelevance())) ) {
                    setChangeRecordItemRelevance(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordVirtualRefInd") ) {
                final Object value = values.remove("ChangeRecordVirtualRefInd");
                if( (value == null) || (!value.equals(getChangeRecordVirtualRefInd())) ) {
                    setChangeRecordVirtualRefInd(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordRefObjectUUID") ) {
                final Object value = values.remove("ChangeRecordRefObjectUUID");
                if( (value == null) || (!value.equals(getChangeRecordRefObjectUUID())) ) {
                    setChangeRecordRefObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordItemProcgStatus") ) {
                final Object value = values.remove("ChangeRecordItemProcgStatus");
                if( (value == null) || (!value.equals(getChangeRecordItemProcgStatus())) ) {
                    setChangeRecordItemProcgStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChangeRecordRefCharcField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeRecordRefCharcField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeRecordRefCharcField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeRecordRefCharcField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

}
