/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordRefClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChangeRecordRefClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Class Assignments to Change Records
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeRecordRefClassType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeRecordRefClass extends VdmEntity<ChangeRecordRefClass>
{

    /**
     * Selector for all available fields of ChangeRecordRefClass.
     *
     */
    public final static ChangeRecordRefClassSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<Boolean> DELETE_MC =
        new ChangeRecordRefClassField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<Boolean> UPDATE_MC =
        new ChangeRecordRefClassField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChangeRecordReferenceUUID" )
    @JsonProperty( "ChangeRecordReferenceUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceUUID" )
    private UUID changeRecordReferenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<UUID> CHANGE_RECORD_REFERENCE_UUID =
        new ChangeRecordRefClassField<UUID>("ChangeRecordReferenceUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @return Issue ID
     */
    @SerializedName( "ChangeRecord" )
    @JsonProperty( "ChangeRecord" )
    @Nullable
    @ODataField( odataName = "ChangeRecord" )
    private String changeRecord;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecord</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD =
        new ChangeRecordRefClassField<String>("ChangeRecord");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "Class" )
    @JsonProperty( "Class" )
    @Nullable
    @ODataField( odataName = "Class" )
    private String classProperty;
    /**
     * Use with available fluent helpers to apply the <b>Class</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CLASS_PROPERTY =
        new ChangeRecordRefClassField<String>("Class");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CLASS_TYPE =
        new ChangeRecordRefClassField<String>("ClassType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_NUMBER =
        new ChangeRecordRefClassField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassName</b>
     * </p>
     *
     * @return Class Description
     */
    @SerializedName( "ClassName" )
    @JsonProperty( "ClassName" )
    @Nullable
    @ODataField( odataName = "ClassName" )
    private String className;
    /**
     * Use with available fluent helpers to apply the <b>ClassName</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CLASS_NAME =
        new ChangeRecordRefClassField<String>("ClassName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassTypeName</b>
     * </p>
     *
     * @return Text describing class type
     */
    @SerializedName( "ClassTypeName" )
    @JsonProperty( "ClassTypeName" )
    @Nullable
    @ODataField( odataName = "ClassTypeName" )
    private String classTypeName;
    /**
     * Use with available fluent helpers to apply the <b>ClassTypeName</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CLASS_TYPE_NAME =
        new ChangeRecordRefClassField<String>("ClassTypeName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<LocalDateTime> VALIDITY_START_DATE =
        new ChangeRecordRefClassField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatus</b>
     * </p>
     *
     * @return Class status
     */
    @SerializedName( "ClassStatus" )
    @JsonProperty( "ClassStatus" )
    @Nullable
    @ODataField( odataName = "ClassStatus" )
    private String classStatus;
    /**
     * Use with available fluent helpers to apply the <b>ClassStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CLASS_STATUS =
        new ChangeRecordRefClassField<String>("ClassStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatusName</b>
     * </p>
     *
     * @return Text for a table entry
     */
    @SerializedName( "ClassStatusName" )
    @JsonProperty( "ClassStatusName" )
    @Nullable
    @ODataField( odataName = "ClassStatusName" )
    private String classStatusName;
    /**
     * Use with available fluent helpers to apply the <b>ClassStatusName</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CLASS_STATUS_NAME =
        new ChangeRecordRefClassField<String>("ClassStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CLASS_INTERNAL_ID =
        new ChangeRecordRefClassField<String>("ClassInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @return Item Processing Status
     */
    @SerializedName( "ChangeRecordItemProcgStatus" )
    @JsonProperty( "ChangeRecordItemProcgStatus" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemProcgStatus" )
    private String changeRecordItemProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemProcgStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD_ITEM_PROCG_STATUS =
        new ChangeRecordRefClassField<String>("ChangeRecordItemProcgStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "ChangeRecordUUID" )
    @JsonProperty( "ChangeRecordUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordUUID" )
    private UUID changeRecordUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<UUID> CHANGE_RECORD_UUID =
        new ChangeRecordRefClassField<UUID>("ChangeRecordUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @return Object Type
     */
    @SerializedName( "ChangeRecordReferenceType" )
    @JsonProperty( "ChangeRecordReferenceType" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceType" )
    private String changeRecordReferenceType;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceType</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD_REFERENCE_TYPE =
        new ChangeRecordRefClassField<String>("ChangeRecordReferenceType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceSubtype</b>
     * </p>
     *
     * @return Object Subtype
     */
    @SerializedName( "ChangeRecordReferenceSubtype" )
    @JsonProperty( "ChangeRecordReferenceSubtype" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceSubtype" )
    private String changeRecordReferenceSubtype;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceSubtype</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD_REFERENCE_SUBTYPE =
        new ChangeRecordRefClassField<String>("ChangeRecordReferenceSubtype");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentChangeRecordRefUUID</b>
     * </p>
     *
     * @return Business Object Node ID
     */
    @SerializedName( "ParentChangeRecordRefUUID" )
    @JsonProperty( "ParentChangeRecordRefUUID" )
    @Nullable
    @ODataField( odataName = "ParentChangeRecordRefUUID" )
    private UUID parentChangeRecordRefUUID;
    /**
     * Use with available fluent helpers to apply the <b>ParentChangeRecordRefUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<UUID> PARENT_CHANGE_RECORD_REF_UUID =
        new ChangeRecordRefClassField<UUID>("ParentChangeRecordRefUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @return Change Record Item Relevance
     */
    @SerializedName( "ChangeRecordItemRelevance" )
    @JsonProperty( "ChangeRecordItemRelevance" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemRelevance" )
    private String changeRecordItemRelevance;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemRelevance</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD_ITEM_RELEVANCE =
        new ChangeRecordRefClassField<String>("ChangeRecordItemRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReference</b>
     * </p>
     *
     * @return Reference Object ID
     */
    @SerializedName( "ChangeRecordReference" )
    @JsonProperty( "ChangeRecordReference" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReference" )
    private String changeRecordReference;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReference</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD_REFERENCE =
        new ChangeRecordRefClassField<String>("ChangeRecordReference");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordStatus</b>
     * </p>
     *
     * @return Change Record Header Status
     */
    @SerializedName( "ChangeRecordStatus" )
    @JsonProperty( "ChangeRecordStatus" )
    @Nullable
    @ODataField( odataName = "ChangeRecordStatus" )
    private String changeRecordStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD_STATUS =
        new ChangeRecordRefClassField<String>("ChangeRecordStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CREATED_BY_USER =
        new ChangeRecordRefClassField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<ZonedDateTime> CREATION_DATE_TIME =
        new ChangeRecordRefClassField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date of Creation
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<LocalDateTime> CREATION_DATE =
        new ChangeRecordRefClassField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> LAST_CHANGED_BY_USER =
        new ChangeRecordRefClassField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ChangeRecordRefClassField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date on Which Last Change Was Made
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<LocalDateTime> LAST_CHANGE_DATE =
        new ChangeRecordRefClassField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordVirtualRefInd</b>
     * </p>
     *
     * @return Virtual object indicated in Change Record
     */
    @SerializedName( "ChangeRecordVirtualRefInd" )
    @JsonProperty( "ChangeRecordVirtualRefInd" )
    @Nullable
    @ODataField( odataName = "ChangeRecordVirtualRefInd" )
    private String changeRecordVirtualRefInd;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordVirtualRefInd</b> field to query operations.
     *
     */
    public final static ChangeRecordRefClassField<String> CHANGE_RECORD_VIRTUAL_REF_IND =
        new ChangeRecordRefClassField<String>("ChangeRecordVirtualRefInd");

    @Nonnull
    @Override
    public Class<ChangeRecordRefClass> getType()
    {
        return ChangeRecordRefClass.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     */
    public void setChangeRecordReferenceUUID( @Nullable final UUID changeRecordReferenceUUID )
    {
        rememberChangedField("ChangeRecordReferenceUUID", this.changeRecordReferenceUUID);
        this.changeRecordReferenceUUID = changeRecordReferenceUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @param changeRecord
     *            Issue ID
     */
    public void setChangeRecord( @Nullable final String changeRecord )
    {
        rememberChangedField("ChangeRecord", this.changeRecord);
        this.changeRecord = changeRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @param classProperty
     *            Class number
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("Class", this.classProperty);
        this.classProperty = classProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassName</b>
     * </p>
     *
     * @param className
     *            Class Description
     */
    public void setClassName( @Nullable final String className )
    {
        rememberChangedField("ClassName", this.className);
        this.className = className;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassTypeName</b>
     * </p>
     *
     * @param classTypeName
     *            Text describing class type
     */
    public void setClassTypeName( @Nullable final String classTypeName )
    {
        rememberChangedField("ClassTypeName", this.classTypeName);
        this.classTypeName = classTypeName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatus</b>
     * </p>
     *
     * @param classStatus
     *            Class status
     */
    public void setClassStatus( @Nullable final String classStatus )
    {
        rememberChangedField("ClassStatus", this.classStatus);
        this.classStatus = classStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatusName</b>
     * </p>
     *
     * @param classStatusName
     *            Text for a table entry
     */
    public void setClassStatusName( @Nullable final String classStatusName )
    {
        rememberChangedField("ClassStatusName", this.classStatusName);
        this.classStatusName = classStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @param changeRecordItemProcgStatus
     *            Item Processing Status
     */
    public void setChangeRecordItemProcgStatus( @Nullable final String changeRecordItemProcgStatus )
    {
        rememberChangedField("ChangeRecordItemProcgStatus", this.changeRecordItemProcgStatus);
        this.changeRecordItemProcgStatus = changeRecordItemProcgStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @param changeRecordUUID
     *            NodeID
     */
    public void setChangeRecordUUID( @Nullable final UUID changeRecordUUID )
    {
        rememberChangedField("ChangeRecordUUID", this.changeRecordUUID);
        this.changeRecordUUID = changeRecordUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @param changeRecordReferenceType
     *            Object Type
     */
    public void setChangeRecordReferenceType( @Nullable final String changeRecordReferenceType )
    {
        rememberChangedField("ChangeRecordReferenceType", this.changeRecordReferenceType);
        this.changeRecordReferenceType = changeRecordReferenceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceSubtype</b>
     * </p>
     *
     * @param changeRecordReferenceSubtype
     *            Object Subtype
     */
    public void setChangeRecordReferenceSubtype( @Nullable final String changeRecordReferenceSubtype )
    {
        rememberChangedField("ChangeRecordReferenceSubtype", this.changeRecordReferenceSubtype);
        this.changeRecordReferenceSubtype = changeRecordReferenceSubtype;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentChangeRecordRefUUID</b>
     * </p>
     *
     * @param parentChangeRecordRefUUID
     *            Business Object Node ID
     */
    public void setParentChangeRecordRefUUID( @Nullable final UUID parentChangeRecordRefUUID )
    {
        rememberChangedField("ParentChangeRecordRefUUID", this.parentChangeRecordRefUUID);
        this.parentChangeRecordRefUUID = parentChangeRecordRefUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @param changeRecordItemRelevance
     *            Change Record Item Relevance
     */
    public void setChangeRecordItemRelevance( @Nullable final String changeRecordItemRelevance )
    {
        rememberChangedField("ChangeRecordItemRelevance", this.changeRecordItemRelevance);
        this.changeRecordItemRelevance = changeRecordItemRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReference</b>
     * </p>
     *
     * @param changeRecordReference
     *            Reference Object ID
     */
    public void setChangeRecordReference( @Nullable final String changeRecordReference )
    {
        rememberChangedField("ChangeRecordReference", this.changeRecordReference);
        this.changeRecordReference = changeRecordReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordStatus</b>
     * </p>
     *
     * @param changeRecordStatus
     *            Change Record Header Status
     */
    public void setChangeRecordStatus( @Nullable final String changeRecordStatus )
    {
        rememberChangedField("ChangeRecordStatus", this.changeRecordStatus);
        this.changeRecordStatus = changeRecordStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date of Creation
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date on Which Last Change Was Made
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordVirtualRefInd</b>
     * </p>
     *
     * @param changeRecordVirtualRefInd
     *            Virtual object indicated in Change Record
     */
    public void setChangeRecordVirtualRefInd( @Nullable final String changeRecordVirtualRefInd )
    {
        rememberChangedField("ChangeRecordVirtualRefInd", this.changeRecordVirtualRefInd);
        this.changeRecordVirtualRefInd = changeRecordVirtualRefInd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeRecordRefClass";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        values.put("ChangeRecord", getChangeRecord());
        values.put("Class", getClassProperty());
        values.put("ClassType", getClassType());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ClassName", getClassName());
        values.put("ClassTypeName", getClassTypeName());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ClassStatus", getClassStatus());
        values.put("ClassStatusName", getClassStatusName());
        values.put("ClassInternalID", getClassInternalID());
        values.put("ChangeRecordItemProcgStatus", getChangeRecordItemProcgStatus());
        values.put("ChangeRecordUUID", getChangeRecordUUID());
        values.put("ChangeRecordReferenceType", getChangeRecordReferenceType());
        values.put("ChangeRecordReferenceSubtype", getChangeRecordReferenceSubtype());
        values.put("ParentChangeRecordRefUUID", getParentChangeRecordRefUUID());
        values.put("ChangeRecordItemRelevance", getChangeRecordItemRelevance());
        values.put("ChangeRecordReference", getChangeRecordReference());
        values.put("ChangeRecordStatus", getChangeRecordStatus());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ChangeRecordVirtualRefInd", getChangeRecordVirtualRefInd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceUUID") ) {
                final Object value = values.remove("ChangeRecordReferenceUUID");
                if( (value == null) || (!value.equals(getChangeRecordReferenceUUID())) ) {
                    setChangeRecordReferenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecord") ) {
                final Object value = values.remove("ChangeRecord");
                if( (value == null) || (!value.equals(getChangeRecord())) ) {
                    setChangeRecord(((String) value));
                }
            }
            if( values.containsKey("Class") ) {
                final Object value = values.remove("Class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ClassName") ) {
                final Object value = values.remove("ClassName");
                if( (value == null) || (!value.equals(getClassName())) ) {
                    setClassName(((String) value));
                }
            }
            if( values.containsKey("ClassTypeName") ) {
                final Object value = values.remove("ClassTypeName");
                if( (value == null) || (!value.equals(getClassTypeName())) ) {
                    setClassTypeName(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassStatus") ) {
                final Object value = values.remove("ClassStatus");
                if( (value == null) || (!value.equals(getClassStatus())) ) {
                    setClassStatus(((String) value));
                }
            }
            if( values.containsKey("ClassStatusName") ) {
                final Object value = values.remove("ClassStatusName");
                if( (value == null) || (!value.equals(getClassStatusName())) ) {
                    setClassStatusName(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordItemProcgStatus") ) {
                final Object value = values.remove("ChangeRecordItemProcgStatus");
                if( (value == null) || (!value.equals(getChangeRecordItemProcgStatus())) ) {
                    setChangeRecordItemProcgStatus(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordUUID") ) {
                final Object value = values.remove("ChangeRecordUUID");
                if( (value == null) || (!value.equals(getChangeRecordUUID())) ) {
                    setChangeRecordUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceType") ) {
                final Object value = values.remove("ChangeRecordReferenceType");
                if( (value == null) || (!value.equals(getChangeRecordReferenceType())) ) {
                    setChangeRecordReferenceType(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceSubtype") ) {
                final Object value = values.remove("ChangeRecordReferenceSubtype");
                if( (value == null) || (!value.equals(getChangeRecordReferenceSubtype())) ) {
                    setChangeRecordReferenceSubtype(((String) value));
                }
            }
            if( values.containsKey("ParentChangeRecordRefUUID") ) {
                final Object value = values.remove("ParentChangeRecordRefUUID");
                if( (value == null) || (!value.equals(getParentChangeRecordRefUUID())) ) {
                    setParentChangeRecordRefUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordItemRelevance") ) {
                final Object value = values.remove("ChangeRecordItemRelevance");
                if( (value == null) || (!value.equals(getChangeRecordItemRelevance())) ) {
                    setChangeRecordItemRelevance(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordReference") ) {
                final Object value = values.remove("ChangeRecordReference");
                if( (value == null) || (!value.equals(getChangeRecordReference())) ) {
                    setChangeRecordReference(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordStatus") ) {
                final Object value = values.remove("ChangeRecordStatus");
                if( (value == null) || (!value.equals(getChangeRecordStatus())) ) {
                    setChangeRecordStatus(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeRecordVirtualRefInd") ) {
                final Object value = values.remove("ChangeRecordVirtualRefInd");
                if( (value == null) || (!value.equals(getChangeRecordVirtualRefInd())) ) {
                    setChangeRecordVirtualRefInd(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChangeRecordRefClassField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeRecordRefClassField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeRecordRefClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeRecordRefClassField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

}
