/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordRefProdnRoutingField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChangeRecordRefProdnRoutingSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Production Routing Assignments to Change Records
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeRecordRefProdnRoutingType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeRecordRefProdnRouting extends VdmEntity<ChangeRecordRefProdnRouting>
{

    /**
     * Selector for all available fields of ChangeRecordRefProdnRouting.
     *
     */
    public final static ChangeRecordRefProdnRoutingSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<Boolean> DELETE_MC =
        new ChangeRecordRefProdnRoutingField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<Boolean> UPDATE_MC =
        new ChangeRecordRefProdnRoutingField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChangeRecordReferenceUUID" )
    @JsonProperty( "ChangeRecordReferenceUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceUUID" )
    private UUID changeRecordReferenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<UUID> CHANGE_RECORD_REFERENCE_UUID =
        new ChangeRecordRefProdnRoutingField<UUID>("ChangeRecordReferenceUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @return Issue ID
     */
    @SerializedName( "ChangeRecord" )
    @JsonProperty( "ChangeRecord" )
    @Nullable
    @ODataField( odataName = "ChangeRecord" )
    private String changeRecord;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecord</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> CHANGE_RECORD =
        new ChangeRecordRefProdnRoutingField<String>("ChangeRecord");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "ChangeRecordUUID" )
    @JsonProperty( "ChangeRecordUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordUUID" )
    private UUID changeRecordUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<UUID> CHANGE_RECORD_UUID =
        new ChangeRecordRefProdnRoutingField<UUID>("ChangeRecordUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @return Object Type
     */
    @SerializedName( "ChangeRecordReferenceType" )
    @JsonProperty( "ChangeRecordReferenceType" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceType" )
    private String changeRecordReferenceType;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceType</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> CHANGE_RECORD_REFERENCE_TYPE =
        new ChangeRecordRefProdnRoutingField<String>("ChangeRecordReferenceType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @SerializedName( "BillOfOperationsGroup" )
    @JsonProperty( "BillOfOperationsGroup" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsGroup" )
    private String billOfOperationsGroup;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsGroup</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> BILL_OF_OPERATIONS_GROUP =
        new ChangeRecordRefProdnRoutingField<String>("BillOfOperationsGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVariant</b>
     * </p>
     *
     * @return Group Counter
     */
    @SerializedName( "BillOfOperationsVariant" )
    @JsonProperty( "BillOfOperationsVariant" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsVariant" )
    private String billOfOperationsVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsVariant</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> BILL_OF_OPERATIONS_VARIANT =
        new ChangeRecordRefProdnRoutingField<String>("BillOfOperationsVariant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @return Change Record Item Relevance
     */
    @SerializedName( "ChangeRecordItemRelevance" )
    @JsonProperty( "ChangeRecordItemRelevance" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemRelevance" )
    private String changeRecordItemRelevance;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemRelevance</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> CHANGE_RECORD_ITEM_RELEVANCE =
        new ChangeRecordRefProdnRoutingField<String>("ChangeRecordItemRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @return Item Processing Status
     */
    @SerializedName( "ChangeRecordItemProcgStatus" )
    @JsonProperty( "ChangeRecordItemProcgStatus" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemProcgStatus" )
    private String changeRecordItemProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemProcgStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> CHANGE_RECORD_ITEM_PROCG_STATUS =
        new ChangeRecordRefProdnRoutingField<String>("ChangeRecordItemProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> CREATED_BY_USER =
        new ChangeRecordRefProdnRoutingField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<ZonedDateTime> CREATION_DATE_TIME =
        new ChangeRecordRefProdnRoutingField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<String> LAST_CHANGED_BY_USER =
        new ChangeRecordRefProdnRoutingField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordRefProdnRoutingField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ChangeRecordRefProdnRoutingField<ZonedDateTime>("LastChangeDateTime");

    @Nonnull
    @Override
    public Class<ChangeRecordRefProdnRouting> getType()
    {
        return ChangeRecordRefProdnRouting.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     */
    public void setChangeRecordReferenceUUID( @Nullable final UUID changeRecordReferenceUUID )
    {
        rememberChangedField("ChangeRecordReferenceUUID", this.changeRecordReferenceUUID);
        this.changeRecordReferenceUUID = changeRecordReferenceUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @param changeRecord
     *            Issue ID
     */
    public void setChangeRecord( @Nullable final String changeRecord )
    {
        rememberChangedField("ChangeRecord", this.changeRecord);
        this.changeRecord = changeRecord;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @param changeRecordUUID
     *            NodeID
     */
    public void setChangeRecordUUID( @Nullable final UUID changeRecordUUID )
    {
        rememberChangedField("ChangeRecordUUID", this.changeRecordUUID);
        this.changeRecordUUID = changeRecordUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @param changeRecordReferenceType
     *            Object Type
     */
    public void setChangeRecordReferenceType( @Nullable final String changeRecordReferenceType )
    {
        rememberChangedField("ChangeRecordReferenceType", this.changeRecordReferenceType);
        this.changeRecordReferenceType = changeRecordReferenceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @param billOfOperationsGroup
     *            Key for Task List Group
     */
    public void setBillOfOperationsGroup( @Nullable final String billOfOperationsGroup )
    {
        rememberChangedField("BillOfOperationsGroup", this.billOfOperationsGroup);
        this.billOfOperationsGroup = billOfOperationsGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVariant</b>
     * </p>
     *
     * @param billOfOperationsVariant
     *            Group Counter
     */
    public void setBillOfOperationsVariant( @Nullable final String billOfOperationsVariant )
    {
        rememberChangedField("BillOfOperationsVariant", this.billOfOperationsVariant);
        this.billOfOperationsVariant = billOfOperationsVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @param changeRecordItemRelevance
     *            Change Record Item Relevance
     */
    public void setChangeRecordItemRelevance( @Nullable final String changeRecordItemRelevance )
    {
        rememberChangedField("ChangeRecordItemRelevance", this.changeRecordItemRelevance);
        this.changeRecordItemRelevance = changeRecordItemRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @param changeRecordItemProcgStatus
     *            Item Processing Status
     */
    public void setChangeRecordItemProcgStatus( @Nullable final String changeRecordItemProcgStatus )
    {
        rememberChangedField("ChangeRecordItemProcgStatus", this.changeRecordItemProcgStatus);
        this.changeRecordItemProcgStatus = changeRecordItemProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeRecordRefProdnRouting";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        values.put("ChangeRecord", getChangeRecord());
        values.put("ChangeRecordUUID", getChangeRecordUUID());
        values.put("ChangeRecordReferenceType", getChangeRecordReferenceType());
        values.put("BillOfOperationsGroup", getBillOfOperationsGroup());
        values.put("BillOfOperationsVariant", getBillOfOperationsVariant());
        values.put("ChangeRecordItemRelevance", getChangeRecordItemRelevance());
        values.put("ChangeRecordItemProcgStatus", getChangeRecordItemProcgStatus());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceUUID") ) {
                final Object value = values.remove("ChangeRecordReferenceUUID");
                if( (value == null) || (!value.equals(getChangeRecordReferenceUUID())) ) {
                    setChangeRecordReferenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecord") ) {
                final Object value = values.remove("ChangeRecord");
                if( (value == null) || (!value.equals(getChangeRecord())) ) {
                    setChangeRecord(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordUUID") ) {
                final Object value = values.remove("ChangeRecordUUID");
                if( (value == null) || (!value.equals(getChangeRecordUUID())) ) {
                    setChangeRecordUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceType") ) {
                final Object value = values.remove("ChangeRecordReferenceType");
                if( (value == null) || (!value.equals(getChangeRecordReferenceType())) ) {
                    setChangeRecordReferenceType(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsGroup") ) {
                final Object value = values.remove("BillOfOperationsGroup");
                if( (value == null) || (!value.equals(getBillOfOperationsGroup())) ) {
                    setBillOfOperationsGroup(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsVariant") ) {
                final Object value = values.remove("BillOfOperationsVariant");
                if( (value == null) || (!value.equals(getBillOfOperationsVariant())) ) {
                    setBillOfOperationsVariant(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordItemRelevance") ) {
                final Object value = values.remove("ChangeRecordItemRelevance");
                if( (value == null) || (!value.equals(getChangeRecordItemRelevance())) ) {
                    setChangeRecordItemRelevance(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordItemProcgStatus") ) {
                final Object value = values.remove("ChangeRecordItemProcgStatus");
                if( (value == null) || (!value.equals(getChangeRecordItemProcgStatus())) ) {
                    setChangeRecordItemProcgStatus(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ChangeRecordRefProdnRoutingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ChangeRecordRefProdnRoutingField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeRecordRefProdnRoutingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeRecordRefProdnRoutingField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

}
