/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
 * ChangeRecordReferenceDoc} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ChangeRecordReferenceDocUpdateFluentHelper
    extends
    FluentHelperUpdate<ChangeRecordReferenceDocUpdateFluentHelper, ChangeRecordReferenceDoc>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity object that will be updated in the S/4HANA system.
     *
     */
    private final ChangeRecordReferenceDoc entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ChangeRecordReferenceDoc to take the updated values from.
     */
    public ChangeRecordReferenceDocUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ChangeRecordReferenceDoc entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ChangeRecordReferenceDoc getEntity()
    {
        return entity;
    }

}
