/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordReferencePSVField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChangeRecordReferencePSVSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Structure Variant Assignments to Change Records
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeRecordReferencePSVType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeRecordReferencePSV extends VdmEntity<ChangeRecordReferencePSV>
{

    /**
     * Selector for all available fields of ChangeRecordReferencePSV.
     *
     */
    public final static ChangeRecordReferencePSVSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<Boolean> DELETE_MC =
        new ChangeRecordReferencePSVField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<Boolean> UPDATE_MC =
        new ChangeRecordReferencePSVField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChangeRecordReferenceUUID" )
    @JsonProperty( "ChangeRecordReferenceUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceUUID" )
    private UUID changeRecordReferenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<UUID> CHANGE_RECORD_REFERENCE_UUID =
        new ChangeRecordReferencePSVField<UUID>("ChangeRecordReferenceUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "ChangeRecordUUID" )
    @JsonProperty( "ChangeRecordUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordUUID" )
    private UUID changeRecordUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<UUID> CHANGE_RECORD_UUID =
        new ChangeRecordReferencePSVField<UUID>("ChangeRecordUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @return Issue ID
     */
    @SerializedName( "ChangeRecord" )
    @JsonProperty( "ChangeRecord" )
    @Nullable
    @ODataField( odataName = "ChangeRecord" )
    private String changeRecord;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecord</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> CHANGE_RECORD =
        new ChangeRecordReferencePSVField<String>("ChangeRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @return Object Type
     */
    @SerializedName( "ChangeRecordReferenceType" )
    @JsonProperty( "ChangeRecordReferenceType" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceType" )
    private String changeRecordReferenceType;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceType</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> CHANGE_RECORD_REFERENCE_TYPE =
        new ChangeRecordReferencePSVField<String>("ChangeRecordReferenceType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> CREATED_BY_USER =
        new ChangeRecordReferencePSVField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<ZonedDateTime> CREATION_DATE_TIME =
        new ChangeRecordReferencePSVField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> LAST_CHANGED_BY_USER =
        new ChangeRecordReferencePSVField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ChangeRecordReferencePSVField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> MATERIAL =
        new ChangeRecordReferencePSVField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "Class" )
    @JsonProperty( "Class" )
    @Nullable
    @ODataField( odataName = "Class" )
    private String classProperty;
    /**
     * Use with available fluent helpers to apply the <b>Class</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> CLASS_PROPERTY =
        new ChangeRecordReferencePSVField<String>("Class");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeName</b>
     * </p>
     *
     * @return iPPE Node Description
     */
    @SerializedName( "ProductStructureNodeName" )
    @JsonProperty( "ProductStructureNodeName" )
    @Nullable
    @ODataField( odataName = "ProductStructureNodeName" )
    private String productStructureNodeName;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureNodeName</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> PRODUCT_STRUCTURE_NODE_NAME =
        new ChangeRecordReferencePSVField<String>("ProductStructureNodeName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucNodeDescription</b>
     * </p>
     *
     * @return Short Text for iPPE Node
     */
    @SerializedName( "ProdStrucNodeDescription" )
    @JsonProperty( "ProdStrucNodeDescription" )
    @Nullable
    @ODataField( odataName = "ProdStrucNodeDescription" )
    private String prodStrucNodeDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucNodeDescription</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> PROD_STRUC_NODE_DESCRIPTION =
        new ChangeRecordReferencePSVField<String>("ProdStrucNodeDescription");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantName</b>
     * </p>
     *
     * @return Variant
     */
    @SerializedName( "ProductStructureVariantName" )
    @JsonProperty( "ProductStructureVariantName" )
    @Nullable
    @ODataField( odataName = "ProductStructureVariantName" )
    private String productStructureVariantName;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureVariantName</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> PRODUCT_STRUCTURE_VARIANT_NAME =
        new ChangeRecordReferencePSVField<String>("ProductStructureVariantName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantDescription</b>
     * </p>
     *
     * @return Description of iPPE Variant
     */
    @SerializedName( "ProdStrucVariantDescription" )
    @JsonProperty( "ProdStrucVariantDescription" )
    @Nullable
    @ODataField( odataName = "ProdStrucVariantDescription" )
    private String prodStrucVariantDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucVariantDescription</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> PROD_STRUC_VARIANT_DESCRIPTION =
        new ChangeRecordReferencePSVField<String>("ProdStrucVariantDescription");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantChangeNumber</b>
     * </p>
     *
     * @return Change Number in iPPE
     */
    @SerializedName( "ProdStrucVariantChangeNumber" )
    @JsonProperty( "ProdStrucVariantChangeNumber" )
    @Nullable
    @ODataField( odataName = "ProdStrucVariantChangeNumber" )
    private String prodStrucVariantChangeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucVariantChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> PROD_STRUC_VARIANT_CHANGE_NUMBER =
        new ChangeRecordReferencePSVField<String>("ProdStrucVariantChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @return Change Record Item Relevance
     */
    @SerializedName( "ChangeRecordItemRelevance" )
    @JsonProperty( "ChangeRecordItemRelevance" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemRelevance" )
    private String changeRecordItemRelevance;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemRelevance</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<String> CHANGE_RECORD_ITEM_RELEVANCE =
        new ChangeRecordReferencePSVField<String>("ChangeRecordItemRelevance");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordRefObjectUUID</b>
     * </p>
     *
     * @return Internal Key of type GUID
     */
    @SerializedName( "ChangeRecordRefObjectUUID" )
    @JsonProperty( "ChangeRecordRefObjectUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordRefObjectUUID" )
    private UUID changeRecordRefObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordRefObjectUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordReferencePSVField<UUID> CHANGE_RECORD_REF_OBJECT_UUID =
        new ChangeRecordReferencePSVField<UUID>("ChangeRecordRefObjectUUID");

    @Nonnull
    @Override
    public Class<ChangeRecordReferencePSV> getType()
    {
        return ChangeRecordReferencePSV.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     */
    public void setChangeRecordReferenceUUID( @Nullable final UUID changeRecordReferenceUUID )
    {
        rememberChangedField("ChangeRecordReferenceUUID", this.changeRecordReferenceUUID);
        this.changeRecordReferenceUUID = changeRecordReferenceUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @param changeRecordUUID
     *            NodeID
     */
    public void setChangeRecordUUID( @Nullable final UUID changeRecordUUID )
    {
        rememberChangedField("ChangeRecordUUID", this.changeRecordUUID);
        this.changeRecordUUID = changeRecordUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @param changeRecord
     *            Issue ID
     */
    public void setChangeRecord( @Nullable final String changeRecord )
    {
        rememberChangedField("ChangeRecord", this.changeRecord);
        this.changeRecord = changeRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @param changeRecordReferenceType
     *            Object Type
     */
    public void setChangeRecordReferenceType( @Nullable final String changeRecordReferenceType )
    {
        rememberChangedField("ChangeRecordReferenceType", this.changeRecordReferenceType);
        this.changeRecordReferenceType = changeRecordReferenceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Product Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @param classProperty
     *            Class number
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("Class", this.classProperty);
        this.classProperty = classProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeName</b>
     * </p>
     *
     * @param productStructureNodeName
     *            iPPE Node Description
     */
    public void setProductStructureNodeName( @Nullable final String productStructureNodeName )
    {
        rememberChangedField("ProductStructureNodeName", this.productStructureNodeName);
        this.productStructureNodeName = productStructureNodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucNodeDescription</b>
     * </p>
     *
     * @param prodStrucNodeDescription
     *            Short Text for iPPE Node
     */
    public void setProdStrucNodeDescription( @Nullable final String prodStrucNodeDescription )
    {
        rememberChangedField("ProdStrucNodeDescription", this.prodStrucNodeDescription);
        this.prodStrucNodeDescription = prodStrucNodeDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantName</b>
     * </p>
     *
     * @param productStructureVariantName
     *            Variant
     */
    public void setProductStructureVariantName( @Nullable final String productStructureVariantName )
    {
        rememberChangedField("ProductStructureVariantName", this.productStructureVariantName);
        this.productStructureVariantName = productStructureVariantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantDescription</b>
     * </p>
     *
     * @param prodStrucVariantDescription
     *            Description of iPPE Variant
     */
    public void setProdStrucVariantDescription( @Nullable final String prodStrucVariantDescription )
    {
        rememberChangedField("ProdStrucVariantDescription", this.prodStrucVariantDescription);
        this.prodStrucVariantDescription = prodStrucVariantDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantChangeNumber</b>
     * </p>
     *
     * @param prodStrucVariantChangeNumber
     *            Change Number in iPPE
     */
    public void setProdStrucVariantChangeNumber( @Nullable final String prodStrucVariantChangeNumber )
    {
        rememberChangedField("ProdStrucVariantChangeNumber", this.prodStrucVariantChangeNumber);
        this.prodStrucVariantChangeNumber = prodStrucVariantChangeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @param changeRecordItemRelevance
     *            Change Record Item Relevance
     */
    public void setChangeRecordItemRelevance( @Nullable final String changeRecordItemRelevance )
    {
        rememberChangedField("ChangeRecordItemRelevance", this.changeRecordItemRelevance);
        this.changeRecordItemRelevance = changeRecordItemRelevance;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordRefObjectUUID</b>
     * </p>
     *
     * @param changeRecordRefObjectUUID
     *            Internal Key of type GUID
     */
    public void setChangeRecordRefObjectUUID( @Nullable final UUID changeRecordRefObjectUUID )
    {
        rememberChangedField("ChangeRecordRefObjectUUID", this.changeRecordRefObjectUUID);
        this.changeRecordRefObjectUUID = changeRecordRefObjectUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeRecordReferencePSV";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        values.put("ChangeRecordUUID", getChangeRecordUUID());
        values.put("ChangeRecord", getChangeRecord());
        values.put("ChangeRecordReferenceType", getChangeRecordReferenceType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("Material", getMaterial());
        values.put("Class", getClassProperty());
        values.put("ProductStructureNodeName", getProductStructureNodeName());
        values.put("ProdStrucNodeDescription", getProdStrucNodeDescription());
        values.put("ProductStructureVariantName", getProductStructureVariantName());
        values.put("ProdStrucVariantDescription", getProdStrucVariantDescription());
        values.put("ProdStrucVariantChangeNumber", getProdStrucVariantChangeNumber());
        values.put("ChangeRecordItemRelevance", getChangeRecordItemRelevance());
        values.put("ChangeRecordRefObjectUUID", getChangeRecordRefObjectUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceUUID") ) {
                final Object value = values.remove("ChangeRecordReferenceUUID");
                if( (value == null) || (!value.equals(getChangeRecordReferenceUUID())) ) {
                    setChangeRecordReferenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordUUID") ) {
                final Object value = values.remove("ChangeRecordUUID");
                if( (value == null) || (!value.equals(getChangeRecordUUID())) ) {
                    setChangeRecordUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecord") ) {
                final Object value = values.remove("ChangeRecord");
                if( (value == null) || (!value.equals(getChangeRecord())) ) {
                    setChangeRecord(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceType") ) {
                final Object value = values.remove("ChangeRecordReferenceType");
                if( (value == null) || (!value.equals(getChangeRecordReferenceType())) ) {
                    setChangeRecordReferenceType(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Class") ) {
                final Object value = values.remove("Class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
            if( values.containsKey("ProductStructureNodeName") ) {
                final Object value = values.remove("ProductStructureNodeName");
                if( (value == null) || (!value.equals(getProductStructureNodeName())) ) {
                    setProductStructureNodeName(((String) value));
                }
            }
            if( values.containsKey("ProdStrucNodeDescription") ) {
                final Object value = values.remove("ProdStrucNodeDescription");
                if( (value == null) || (!value.equals(getProdStrucNodeDescription())) ) {
                    setProdStrucNodeDescription(((String) value));
                }
            }
            if( values.containsKey("ProductStructureVariantName") ) {
                final Object value = values.remove("ProductStructureVariantName");
                if( (value == null) || (!value.equals(getProductStructureVariantName())) ) {
                    setProductStructureVariantName(((String) value));
                }
            }
            if( values.containsKey("ProdStrucVariantDescription") ) {
                final Object value = values.remove("ProdStrucVariantDescription");
                if( (value == null) || (!value.equals(getProdStrucVariantDescription())) ) {
                    setProdStrucVariantDescription(((String) value));
                }
            }
            if( values.containsKey("ProdStrucVariantChangeNumber") ) {
                final Object value = values.remove("ProdStrucVariantChangeNumber");
                if( (value == null) || (!value.equals(getProdStrucVariantChangeNumber())) ) {
                    setProdStrucVariantChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordItemRelevance") ) {
                final Object value = values.remove("ChangeRecordItemRelevance");
                if( (value == null) || (!value.equals(getChangeRecordItemRelevance())) ) {
                    setChangeRecordItemRelevance(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordRefObjectUUID") ) {
                final Object value = values.remove("ChangeRecordRefObjectUUID");
                if( (value == null) || (!value.equals(getChangeRecordRefObjectUUID())) ) {
                    setChangeRecordRefObjectUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChangeRecordReferencePSVField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeRecordReferencePSVField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeRecordReferencePSVField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeRecordReferencePSVField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

}
