/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChgRecdEquipBOMField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChgRecdEquipBOMSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Equipment BOM assign to Chg Records
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChgRecdEquipBOMType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChgRecdEquipBOM extends VdmEntity<ChgRecdEquipBOM>
{

    /**
     * Selector for all available fields of ChgRecdEquipBOM.
     *
     */
    public final static ChgRecdEquipBOMSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<Boolean> DELETE_MC = new ChgRecdEquipBOMField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<Boolean> UPDATE_MC = new ChgRecdEquipBOMField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChangeRecordReferenceUUID" )
    @JsonProperty( "ChangeRecordReferenceUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceUUID" )
    private UUID changeRecordReferenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceUUID</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<UUID> CHANGE_RECORD_REFERENCE_UUID =
        new ChgRecdEquipBOMField<UUID>("ChangeRecordReferenceUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @return Issue ID
     */
    @SerializedName( "ChangeRecord" )
    @JsonProperty( "ChangeRecord" )
    @Nullable
    @ODataField( odataName = "ChangeRecord" )
    private String changeRecord;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecord</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_RECORD = new ChgRecdEquipBOMField<String>("ChangeRecord");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> EQUIPMENT = new ChgRecdEquipBOMField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> PLANT = new ChgRecdEquipBOMField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsage</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> BILL_OF_MATERIAL_VARIANT_USAGE =
        new ChgRecdEquipBOMField<String>("BillOfMaterialVariantUsage");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> BILL_OF_MATERIAL_VARIANT =
        new ChgRecdEquipBOMField<String>("BillOfMaterialVariant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "ChangeRecordUUID" )
    @JsonProperty( "ChangeRecordUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordUUID" )
    private UUID changeRecordUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordUUID</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<UUID> CHANGE_RECORD_UUID =
        new ChgRecdEquipBOMField<UUID>("ChangeRecordUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @return Object Type
     */
    @SerializedName( "ChangeRecordReferenceType" )
    @JsonProperty( "ChangeRecordReferenceType" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceType" )
    private String changeRecordReferenceType;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceType</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_RECORD_REFERENCE_TYPE =
        new ChgRecdEquipBOMField<String>("ChangeRecordReferenceType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceSubtype</b>
     * </p>
     *
     * @return Object Subtype
     */
    @SerializedName( "ChangeRecordReferenceSubtype" )
    @JsonProperty( "ChangeRecordReferenceSubtype" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReferenceSubtype" )
    private String changeRecordReferenceSubtype;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReferenceSubtype</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_RECORD_REFERENCE_SUBTYPE =
        new ChgRecdEquipBOMField<String>("ChangeRecordReferenceSubtype");
    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReference</b>
     * </p>
     *
     * @return Reference Object ID
     */
    @SerializedName( "ChangeRecordReference" )
    @JsonProperty( "ChangeRecordReference" )
    @Nullable
    @ODataField( odataName = "ChangeRecordReference" )
    private String changeRecordReference;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordReference</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_RECORD_REFERENCE =
        new ChgRecdEquipBOMField<String>("ChangeRecordReference");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentChangeRecordRefUUID</b>
     * </p>
     *
     * @return Business Object Node ID
     */
    @SerializedName( "ParentChangeRecordRefUUID" )
    @JsonProperty( "ParentChangeRecordRefUUID" )
    @Nullable
    @ODataField( odataName = "ParentChangeRecordRefUUID" )
    private UUID parentChangeRecordRefUUID;
    /**
     * Use with available fluent helpers to apply the <b>ParentChangeRecordRefUUID</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<UUID> PARENT_CHANGE_RECORD_REF_UUID =
        new ChgRecdEquipBOMField<UUID>("ParentChangeRecordRefUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMainReference</b>
     * </p>
     *
     * @return Main Reference
     */
    @SerializedName( "IsMainReference" )
    @JsonProperty( "IsMainReference" )
    @Nullable
    @ODataField( odataName = "IsMainReference" )
    private String isMainReference;
    /**
     * Use with available fluent helpers to apply the <b>IsMainReference</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> IS_MAIN_REFERENCE =
        new ChgRecdEquipBOMField<String>("IsMainReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> BILL_OF_MATERIAL_CATEGORY =
        new ChgRecdEquipBOMField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_NUMBER = new ChgRecdEquipBOMField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CREATED_BY_USER =
        new ChgRecdEquipBOMField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<ZonedDateTime> CREATION_DATE_TIME =
        new ChgRecdEquipBOMField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> LAST_CHANGED_BY_USER =
        new ChgRecdEquipBOMField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ChgRecdEquipBOMField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @return Change Record Item Relevance
     */
    @SerializedName( "ChangeRecordItemRelevance" )
    @JsonProperty( "ChangeRecordItemRelevance" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemRelevance" )
    private String changeRecordItemRelevance;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemRelevance</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_RECORD_ITEM_RELEVANCE =
        new ChgRecdEquipBOMField<String>("ChangeRecordItemRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordVirtualRefInd</b>
     * </p>
     *
     * @return Virtual object indicated in Change Record
     */
    @SerializedName( "ChangeRecordVirtualRefInd" )
    @JsonProperty( "ChangeRecordVirtualRefInd" )
    @Nullable
    @ODataField( odataName = "ChangeRecordVirtualRefInd" )
    private String changeRecordVirtualRefInd;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordVirtualRefInd</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_RECORD_VIRTUAL_REF_IND =
        new ChgRecdEquipBOMField<String>("ChangeRecordVirtualRefInd");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Bill of Material
     */
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> BILL_OF_MATERIAL =
        new ChgRecdEquipBOMField<String>("BillOfMaterial");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordRefObjectUUID</b>
     * </p>
     *
     * @return Internal Key of type GUID
     */
    @SerializedName( "ChangeRecordRefObjectUUID" )
    @JsonProperty( "ChangeRecordRefObjectUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordRefObjectUUID" )
    private UUID changeRecordRefObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordRefObjectUUID</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<UUID> CHANGE_RECORD_REF_OBJECT_UUID =
        new ChgRecdEquipBOMField<UUID>("ChangeRecordRefObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @return Item Processing Status
     */
    @SerializedName( "ChangeRecordItemProcgStatus" )
    @JsonProperty( "ChangeRecordItemProcgStatus" )
    @Nullable
    @ODataField( odataName = "ChangeRecordItemProcgStatus" )
    private String changeRecordItemProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordItemProcgStatus</b> field to query operations.
     *
     */
    public final static ChgRecdEquipBOMField<String> CHANGE_RECORD_ITEM_PROCG_STATUS =
        new ChgRecdEquipBOMField<String>("ChangeRecordItemProcgStatus");

    @Nonnull
    @Override
    public Class<ChgRecdEquipBOM> getType()
    {
        return ChgRecdEquipBOM.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceUUID</b>
     * </p>
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     */
    public void setChangeRecordReferenceUUID( @Nullable final UUID changeRecordReferenceUUID )
    {
        rememberChangedField("ChangeRecordReferenceUUID", this.changeRecordReferenceUUID);
        this.changeRecordReferenceUUID = changeRecordReferenceUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @param changeRecord
     *            Issue ID
     */
    public void setChangeRecord( @Nullable final String changeRecord )
    {
        rememberChangedField("ChangeRecord", this.changeRecord);
        this.changeRecord = changeRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @param changeRecordUUID
     *            NodeID
     */
    public void setChangeRecordUUID( @Nullable final UUID changeRecordUUID )
    {
        rememberChangedField("ChangeRecordUUID", this.changeRecordUUID);
        this.changeRecordUUID = changeRecordUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceType</b>
     * </p>
     *
     * @param changeRecordReferenceType
     *            Object Type
     */
    public void setChangeRecordReferenceType( @Nullable final String changeRecordReferenceType )
    {
        rememberChangedField("ChangeRecordReferenceType", this.changeRecordReferenceType);
        this.changeRecordReferenceType = changeRecordReferenceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReferenceSubtype</b>
     * </p>
     *
     * @param changeRecordReferenceSubtype
     *            Object Subtype
     */
    public void setChangeRecordReferenceSubtype( @Nullable final String changeRecordReferenceSubtype )
    {
        rememberChangedField("ChangeRecordReferenceSubtype", this.changeRecordReferenceSubtype);
        this.changeRecordReferenceSubtype = changeRecordReferenceSubtype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordReference</b>
     * </p>
     *
     * @param changeRecordReference
     *            Reference Object ID
     */
    public void setChangeRecordReference( @Nullable final String changeRecordReference )
    {
        rememberChangedField("ChangeRecordReference", this.changeRecordReference);
        this.changeRecordReference = changeRecordReference;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentChangeRecordRefUUID</b>
     * </p>
     *
     * @param parentChangeRecordRefUUID
     *            Business Object Node ID
     */
    public void setParentChangeRecordRefUUID( @Nullable final UUID parentChangeRecordRefUUID )
    {
        rememberChangedField("ParentChangeRecordRefUUID", this.parentChangeRecordRefUUID);
        this.parentChangeRecordRefUUID = parentChangeRecordRefUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMainReference</b>
     * </p>
     *
     * @param isMainReference
     *            Main Reference
     */
    public void setIsMainReference( @Nullable final String isMainReference )
    {
        rememberChangedField("IsMainReference", this.isMainReference);
        this.isMainReference = isMainReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemRelevance</b>
     * </p>
     *
     * @param changeRecordItemRelevance
     *            Change Record Item Relevance
     */
    public void setChangeRecordItemRelevance( @Nullable final String changeRecordItemRelevance )
    {
        rememberChangedField("ChangeRecordItemRelevance", this.changeRecordItemRelevance);
        this.changeRecordItemRelevance = changeRecordItemRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordVirtualRefInd</b>
     * </p>
     *
     * @param changeRecordVirtualRefInd
     *            Virtual object indicated in Change Record
     */
    public void setChangeRecordVirtualRefInd( @Nullable final String changeRecordVirtualRefInd )
    {
        rememberChangedField("ChangeRecordVirtualRefInd", this.changeRecordVirtualRefInd);
        this.changeRecordVirtualRefInd = changeRecordVirtualRefInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordRefObjectUUID</b>
     * </p>
     *
     * @param changeRecordRefObjectUUID
     *            Internal Key of type GUID
     */
    public void setChangeRecordRefObjectUUID( @Nullable final UUID changeRecordRefObjectUUID )
    {
        rememberChangedField("ChangeRecordRefObjectUUID", this.changeRecordRefObjectUUID);
        this.changeRecordRefObjectUUID = changeRecordRefObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordItemProcgStatus</b>
     * </p>
     *
     * @param changeRecordItemProcgStatus
     *            Item Processing Status
     */
    public void setChangeRecordItemProcgStatus( @Nullable final String changeRecordItemProcgStatus )
    {
        rememberChangedField("ChangeRecordItemProcgStatus", this.changeRecordItemProcgStatus);
        this.changeRecordItemProcgStatus = changeRecordItemProcgStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChgRecdEquipBOM";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeRecordReferenceUUID", getChangeRecordReferenceUUID());
        values.put("ChangeRecord", getChangeRecord());
        values.put("Equipment", getEquipment());
        values.put("Plant", getPlant());
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("ChangeRecordUUID", getChangeRecordUUID());
        values.put("ChangeRecordReferenceType", getChangeRecordReferenceType());
        values.put("ChangeRecordReferenceSubtype", getChangeRecordReferenceSubtype());
        values.put("ChangeRecordReference", getChangeRecordReference());
        values.put("ParentChangeRecordRefUUID", getParentChangeRecordRefUUID());
        values.put("IsMainReference", getIsMainReference());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("ChangeNumber", getChangeNumber());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ChangeRecordItemRelevance", getChangeRecordItemRelevance());
        values.put("ChangeRecordVirtualRefInd", getChangeRecordVirtualRefInd());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("ChangeRecordRefObjectUUID", getChangeRecordRefObjectUUID());
        values.put("ChangeRecordItemProcgStatus", getChangeRecordItemProcgStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceUUID") ) {
                final Object value = values.remove("ChangeRecordReferenceUUID");
                if( (value == null) || (!value.equals(getChangeRecordReferenceUUID())) ) {
                    setChangeRecordReferenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecord") ) {
                final Object value = values.remove("ChangeRecord");
                if( (value == null) || (!value.equals(getChangeRecord())) ) {
                    setChangeRecord(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordUUID") ) {
                final Object value = values.remove("ChangeRecordUUID");
                if( (value == null) || (!value.equals(getChangeRecordUUID())) ) {
                    setChangeRecordUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceType") ) {
                final Object value = values.remove("ChangeRecordReferenceType");
                if( (value == null) || (!value.equals(getChangeRecordReferenceType())) ) {
                    setChangeRecordReferenceType(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordReferenceSubtype") ) {
                final Object value = values.remove("ChangeRecordReferenceSubtype");
                if( (value == null) || (!value.equals(getChangeRecordReferenceSubtype())) ) {
                    setChangeRecordReferenceSubtype(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordReference") ) {
                final Object value = values.remove("ChangeRecordReference");
                if( (value == null) || (!value.equals(getChangeRecordReference())) ) {
                    setChangeRecordReference(((String) value));
                }
            }
            if( values.containsKey("ParentChangeRecordRefUUID") ) {
                final Object value = values.remove("ParentChangeRecordRefUUID");
                if( (value == null) || (!value.equals(getParentChangeRecordRefUUID())) ) {
                    setParentChangeRecordRefUUID(((UUID) value));
                }
            }
            if( values.containsKey("IsMainReference") ) {
                final Object value = values.remove("IsMainReference");
                if( (value == null) || (!value.equals(getIsMainReference())) ) {
                    setIsMainReference(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ChangeRecordItemRelevance") ) {
                final Object value = values.remove("ChangeRecordItemRelevance");
                if( (value == null) || (!value.equals(getChangeRecordItemRelevance())) ) {
                    setChangeRecordItemRelevance(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordVirtualRefInd") ) {
                final Object value = values.remove("ChangeRecordVirtualRefInd");
                if( (value == null) || (!value.equals(getChangeRecordVirtualRefInd())) ) {
                    setChangeRecordVirtualRefInd(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordRefObjectUUID") ) {
                final Object value = values.remove("ChangeRecordRefObjectUUID");
                if( (value == null) || (!value.equals(getChangeRecordRefObjectUUID())) ) {
                    setChangeRecordRefObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordItemProcgStatus") ) {
                final Object value = values.remove("ChangeRecordItemProcgStatus");
                if( (value == null) || (!value.equals(getChangeRecordItemProcgStatus())) ) {
                    setChangeRecordItemProcgStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChgRecdEquipBOMField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChgRecdEquipBOMField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChgRecdEquipBOMField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChgRecdEquipBOMField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

}
