/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChgRecdPLMEPDCollabnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChgRecdPLMEPDCollabnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Change Record EPD Collaboration
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChgRecdPLMEPDCollabn_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChgRecdPLMEPDCollabn extends VdmEntity<ChgRecdPLMEPDCollabn>
{

    /**
     * Selector for all available fields of ChgRecdPLMEPDCollabn.
     *
     */
    public final static ChgRecdPLMEPDCollabnSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<Boolean> DELETE_MC =
        new ChgRecdPLMEPDCollabnField<Boolean>("Delete_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChgRecdPLMEPDCollabnUUID" )
    @JsonProperty( "ChgRecdPLMEPDCollabnUUID" )
    @Nullable
    @ODataField( odataName = "ChgRecdPLMEPDCollabnUUID" )
    private UUID chgRecdPLMEPDCollabnUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChgRecdPLMEPDCollabnUUID</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<UUID> CHG_RECD_PLMEPD_COLLABN_UUID =
        new ChgRecdPLMEPDCollabnField<UUID>("ChgRecdPLMEPDCollabnUUID");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChangeRecordUUID" )
    @JsonProperty( "ChangeRecordUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordUUID" )
    private UUID changeRecordUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordUUID</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<UUID> CHANGE_RECORD_UUID =
        new ChgRecdPLMEPDCollabnField<UUID>("ChangeRecordUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnType</b>
     * </p>
     *
     * @return Collaboration Type
     */
    @SerializedName( "ChgRecdPLMEPDCollabnType" )
    @JsonProperty( "ChgRecdPLMEPDCollabnType" )
    @Nullable
    @ODataField( odataName = "ChgRecdPLMEPDCollabnType" )
    private String chgRecdPLMEPDCollabnType;
    /**
     * Use with available fluent helpers to apply the <b>ChgRecdPLMEPDCollabnType</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<String> CHG_RECD_PLMEPD_COLLABN_TYPE =
        new ChgRecdPLMEPDCollabnField<String>("ChgRecdPLMEPDCollabnType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<String> CREATED_BY_USER =
        new ChgRecdPLMEPDCollabnField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<ZonedDateTime> CREATION_DATE_TIME =
        new ChgRecdPLMEPDCollabnField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnSourceID</b>
     * </p>
     *
     * @return EPD Collaboration Source
     */
    @SerializedName( "ChgRecdPLMEPDCollabnSourceID" )
    @JsonProperty( "ChgRecdPLMEPDCollabnSourceID" )
    @Nullable
    @ODataField( odataName = "ChgRecdPLMEPDCollabnSourceID" )
    private String chgRecdPLMEPDCollabnSourceID;
    /**
     * Use with available fluent helpers to apply the <b>ChgRecdPLMEPDCollabnSourceID</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<String> CHG_RECD_PLMEPD_COLLABN_SOURCE_ID =
        new ChgRecdPLMEPDCollabnField<String>("ChgRecdPLMEPDCollabnSourceID");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnID</b>
     * </p>
     *
     * @return EPD Collaboration Internal ID in CR
     */
    @SerializedName( "ChgRecdPLMEPDCollabnID" )
    @JsonProperty( "ChgRecdPLMEPDCollabnID" )
    @Nullable
    @ODataField( odataName = "ChgRecdPLMEPDCollabnID" )
    private String chgRecdPLMEPDCollabnID;
    /**
     * Use with available fluent helpers to apply the <b>ChgRecdPLMEPDCollabnID</b> field to query operations.
     *
     */
    public final static ChgRecdPLMEPDCollabnField<String> CHG_RECD_PLMEPD_COLLABN_ID =
        new ChgRecdPLMEPDCollabnField<String>("ChgRecdPLMEPDCollabnID");

    @Nonnull
    @Override
    public Class<ChgRecdPLMEPDCollabn> getType()
    {
        return ChgRecdPLMEPDCollabn.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnUUID</b>
     * </p>
     *
     * @param chgRecdPLMEPDCollabnUUID
     *            NodeID
     */
    public void setChgRecdPLMEPDCollabnUUID( @Nullable final UUID chgRecdPLMEPDCollabnUUID )
    {
        rememberChangedField("ChgRecdPLMEPDCollabnUUID", this.chgRecdPLMEPDCollabnUUID);
        this.chgRecdPLMEPDCollabnUUID = chgRecdPLMEPDCollabnUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @param changeRecordUUID
     *            NodeID
     */
    public void setChangeRecordUUID( @Nullable final UUID changeRecordUUID )
    {
        rememberChangedField("ChangeRecordUUID", this.changeRecordUUID);
        this.changeRecordUUID = changeRecordUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnType</b>
     * </p>
     *
     * @param chgRecdPLMEPDCollabnType
     *            Collaboration Type
     */
    public void setChgRecdPLMEPDCollabnType( @Nullable final String chgRecdPLMEPDCollabnType )
    {
        rememberChangedField("ChgRecdPLMEPDCollabnType", this.chgRecdPLMEPDCollabnType);
        this.chgRecdPLMEPDCollabnType = chgRecdPLMEPDCollabnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnSourceID</b>
     * </p>
     *
     * @param chgRecdPLMEPDCollabnSourceID
     *            EPD Collaboration Source
     */
    public void setChgRecdPLMEPDCollabnSourceID( @Nullable final String chgRecdPLMEPDCollabnSourceID )
    {
        rememberChangedField("ChgRecdPLMEPDCollabnSourceID", this.chgRecdPLMEPDCollabnSourceID);
        this.chgRecdPLMEPDCollabnSourceID = chgRecdPLMEPDCollabnSourceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdPLMEPDCollabnID</b>
     * </p>
     *
     * @param chgRecdPLMEPDCollabnID
     *            EPD Collaboration Internal ID in CR
     */
    public void setChgRecdPLMEPDCollabnID( @Nullable final String chgRecdPLMEPDCollabnID )
    {
        rememberChangedField("ChgRecdPLMEPDCollabnID", this.chgRecdPLMEPDCollabnID);
        this.chgRecdPLMEPDCollabnID = chgRecdPLMEPDCollabnID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChgRecdPLMEPDCollabn";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChgRecdPLMEPDCollabnUUID", getChgRecdPLMEPDCollabnUUID());
        result.put("ChangeRecordUUID", getChangeRecordUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("ChgRecdPLMEPDCollabnUUID", getChgRecdPLMEPDCollabnUUID());
        values.put("ChangeRecordUUID", getChangeRecordUUID());
        values.put("ChgRecdPLMEPDCollabnType", getChgRecdPLMEPDCollabnType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("ChgRecdPLMEPDCollabnSourceID", getChgRecdPLMEPDCollabnSourceID());
        values.put("ChgRecdPLMEPDCollabnID", getChgRecdPLMEPDCollabnID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChgRecdPLMEPDCollabnUUID") ) {
                final Object value = values.remove("ChgRecdPLMEPDCollabnUUID");
                if( (value == null) || (!value.equals(getChgRecdPLMEPDCollabnUUID())) ) {
                    setChgRecdPLMEPDCollabnUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecordUUID") ) {
                final Object value = values.remove("ChangeRecordUUID");
                if( (value == null) || (!value.equals(getChangeRecordUUID())) ) {
                    setChangeRecordUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChgRecdPLMEPDCollabnType") ) {
                final Object value = values.remove("ChgRecdPLMEPDCollabnType");
                if( (value == null) || (!value.equals(getChgRecdPLMEPDCollabnType())) ) {
                    setChgRecdPLMEPDCollabnType(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ChgRecdPLMEPDCollabnSourceID") ) {
                final Object value = values.remove("ChgRecdPLMEPDCollabnSourceID");
                if( (value == null) || (!value.equals(getChgRecdPLMEPDCollabnSourceID())) ) {
                    setChgRecdPLMEPDCollabnSourceID(((String) value));
                }
            }
            if( values.containsKey("ChgRecdPLMEPDCollabnID") ) {
                final Object value = values.remove("ChgRecdPLMEPDCollabnID");
                if( (value == null) || (!value.equals(getChgRecdPLMEPDCollabnID())) ) {
                    setChgRecdPLMEPDCollabnID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChgRecdPLMEPDCollabnField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChgRecdPLMEPDCollabnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChgRecdPLMEPDCollabnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChgRecdPLMEPDCollabnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

}
