/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChgRecdPLMEPDCollabnSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn ChgRecdPLMEPDCollabn}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ChgRecdPLMEPDCollabnByKeyFluentHelper
    extends
    FluentHelperByKey<ChgRecdPLMEPDCollabnByKeyFluentHelper, ChgRecdPLMEPDCollabn, ChgRecdPLMEPDCollabnSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     * ChgRecdPLMEPDCollabn} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ChgRecdPLMEPDCollabn}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ChgRecdPLMEPDCollabn}
     * @param changeRecordUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param chgRecdPLMEPDCollabnUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ChgRecdPLMEPDCollabnByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID chgRecdPLMEPDCollabnUUID,
        final UUID changeRecordUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ChgRecdPLMEPDCollabnUUID", chgRecdPLMEPDCollabnUUID);
        this.key.put("ChangeRecordUUID", changeRecordUUID);
    }

    @Override
    @Nonnull
    protected Class<ChgRecdPLMEPDCollabn> getEntityClass()
    {
        return ChgRecdPLMEPDCollabn.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
