/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
 * ChgRecdRefEquipTskList} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ChgRecdRefEquipTskListUpdateFluentHelper
    extends
    FluentHelperUpdate<ChgRecdRefEquipTskListUpdateFluentHelper, ChgRecdRefEquipTskList>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity object that will be updated in the S/4HANA system.
     *
     */
    private final ChgRecdRefEquipTskList entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ChgRecdRefEquipTskList to take the updated values from.
     */
    public ChgRecdRefEquipTskListUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ChgRecdRefEquipTskList entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ChgRecdRefEquipTskList getEntity()
    {
        return entity;
    }

}
