/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService ChangeRecordService}.
 *
 */
public interface ChangeRecordServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ChangeRecordServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ChangeRecordServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     * entity and save it to the S/4HANA system.
     *
     * @param changeRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet createChangeRecord( @Nonnull final ChangeRecord changeRecord );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord
     * ChangeRecord} entity and save it to the S/4HANA system.
     *
     * @param changeRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet updateChangeRecord( @Nonnull final ChangeRecord changeRecord );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *            ChangeRecordRefCharc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordRefCharc( @Nonnull final ChangeRecordRefCharc changeRecordRefCharc );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *            ChangeRecordRefCharc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordRefCharc( @Nonnull final ChangeRecordRefCharc changeRecordRefCharc );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entity in the S/4HANA system.
     *
     * @param changeRecordRefCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *            ChangeRecordRefCharc} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordRefCharc( @Nonnull final ChangeRecordRefCharc changeRecordRefCharc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *            ChangeRecordRefClass} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordRefClass( @Nonnull final ChangeRecordRefClass changeRecordRefClass );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *            ChangeRecordRefClass} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordRefClass( @Nonnull final ChangeRecordRefClass changeRecordRefClass );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entity in the S/4HANA system.
     *
     * @param changeRecordRefClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *            ChangeRecordRefClass} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordRefClass( @Nonnull final ChangeRecordRefClass changeRecordRefClass );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBit
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *            ChangeRecordReferenceBit} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordReferenceBit( @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBit
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *            ChangeRecordReferenceBit} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordReferenceBit( @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceBit
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *            ChangeRecordReferenceBit} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordReferenceBit( @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *            ChangeRecordReferenceBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordReferenceBOM( @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *            ChangeRecordReferenceBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordReferenceBOM( @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *            ChangeRecordReferenceBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordReferenceBOM( @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *            ChangeRecordReferenceDoc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordReferenceDoc( @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *            ChangeRecordReferenceDoc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordReferenceDoc( @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *            ChangeRecordReferenceDoc} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordReferenceDoc( @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *            ChangeRecordReferenceMat} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordReferenceMat( @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *            ChangeRecordReferenceMat} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordReferenceMat( @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *            ChangeRecordReferenceMat} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordReferenceMat( @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferencePSV
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *            ChangeRecordReferencePSV} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordReferencePSV( @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferencePSV
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *            ChangeRecordReferencePSV} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordReferencePSV( @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entity in the S/4HANA system.
     *
     * @param changeRecordReferencePSV
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *            ChangeRecordReferencePSV} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordReferencePSV( @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefMasterRecipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *            ChangeRecordRefMasterRecipe} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordRefMasterRecipe( @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefMasterRecipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *            ChangeRecordRefMasterRecipe} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordRefMasterRecipe( @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entity in the S/4HANA system.
     *
     * @param changeRecordRefMasterRecipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *            ChangeRecordRefMasterRecipe} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordRefMasterRecipe( @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefProdnRouting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *            ChangeRecordRefProdnRouting} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChangeRecordRefProdnRouting( @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefProdnRouting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *            ChangeRecordRefProdnRouting} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChangeRecordRefProdnRouting( @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entity in the S/4HANA system.
     *
     * @param changeRecordRefProdnRouting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *            ChangeRecordRefProdnRouting} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChangeRecordRefProdnRouting( @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdEquipBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     *            ChgRecdEquipBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet createChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdEquipBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     *            ChgRecdEquipBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet updateChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entity in the S/4HANA system.
     *
     * @param chgRecdEquipBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     *            ChgRecdEquipBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet deleteChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *            ChgRecdFuncLocBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet createChgRecdFuncLocBOM( @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *            ChgRecdFuncLocBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet updateChgRecdFuncLocBOM( @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entity in the S/4HANA system.
     *
     * @param chgRecdFuncLocBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *            ChgRecdFuncLocBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet deleteChgRecdFuncLocBOM( @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *            ChgRecdFuncLocTskList} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChgRecdFuncLocTskList( @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *            ChgRecdFuncLocTskList} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChgRecdFuncLocTskList( @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entity in the S/4HANA system.
     *
     * @param chgRecdFuncLocTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *            ChgRecdFuncLocTskList} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChgRecdFuncLocTskList( @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdObjPgMaintTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *            ChgRecdObjPgMaintTskList} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChgRecdObjPgMaintTskList( @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdObjPgMaintTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *            ChgRecdObjPgMaintTskList} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChgRecdObjPgMaintTskList( @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entity in the S/4HANA system.
     *
     * @param chgRecdObjPgMaintTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *            ChgRecdObjPgMaintTskList} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChgRecdObjPgMaintTskList( @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     * ChgRecdPLMEPDCollabn} entity and save it to the S/4HANA system.
     *
     * @param chgRecdPLMEPDCollabn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *            ChgRecdPLMEPDCollabn} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChgRecdPLMEPDCollabn( @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     * ChgRecdPLMEPDCollabn} entity in the S/4HANA system.
     *
     * @param chgRecdPLMEPDCollabn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *            ChgRecdPLMEPDCollabn} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChgRecdPLMEPDCollabn( @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEngBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *            ChgRecdRefEngBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet createChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEngBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *            ChgRecdRefEngBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet updateChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefEngBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *            ChgRecdRefEngBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet deleteChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEquipTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *            ChgRecdRefEquipTskList} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        createChgRecdRefEquipTskList( @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEquipTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *            ChgRecdRefEquipTskList} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        updateChgRecdRefEquipTskList( @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity in the S/4HANA system.
     *
     * @param chgRecdRefEquipTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *            ChgRecdRefEquipTskList} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet
        deleteChgRecdRefEquipTskList( @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefMfgBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *            ChgRecdRefMfgBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet createChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefMfgBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *            ChgRecdRefMfgBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet updateChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefMfgBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *            ChgRecdRefMfgBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet deleteChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefStdBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *            ChgRecdRefStdBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet createChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefStdBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *            ChgRecdRefStdBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet updateChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefStdBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *            ChgRecdRefStdBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet deleteChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefVarBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *            ChgRecdRefVarBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet createChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefVarBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *            ChgRecdRefVarBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet updateChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefVarBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *            ChgRecdRefVarBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeRecordServiceBatchChangeSet deleteChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM );

}
