/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ChangeRecordServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService ChangeRecordService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultChangeRecordServiceBatch
    extends
    BatchFluentHelperBasic<ChangeRecordServiceBatch, ChangeRecordServiceBatchChangeSet>
    implements
    ChangeRecordServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultChangeRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultChangeRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultChangeRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultChangeRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultChangeRecordServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultChangeRecordServiceBatchChangeSet(this, service);
    }

}
