/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM;

/**
 * Implementation of the {@link ChangeRecordServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService ChangeRecordService}.
 *
 */
public class DefaultChangeRecordServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ChangeRecordServiceBatch, ChangeRecordServiceBatchChangeSet>
    implements
    ChangeRecordServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService service;

    @SuppressWarnings( "deprecation" )
    DefaultChangeRecordServiceBatchChangeSet(
        @Nonnull final DefaultChangeRecordServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultChangeRecordServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecord( @Nonnull final ChangeRecord changeRecord )
    {
        return addRequestCreate(service::createChangeRecord, changeRecord);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecord( @Nonnull final ChangeRecord changeRecord )
    {
        return addRequestUpdate(service::updateChangeRecord, changeRecord);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordRefCharc(
        @Nonnull final ChangeRecordRefCharc changeRecordRefCharc )
    {
        return addRequestCreate(service::createChangeRecordRefCharc, changeRecordRefCharc);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordRefCharc(
        @Nonnull final ChangeRecordRefCharc changeRecordRefCharc )
    {
        return addRequestUpdate(service::updateChangeRecordRefCharc, changeRecordRefCharc);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordRefCharc(
        @Nonnull final ChangeRecordRefCharc changeRecordRefCharc )
    {
        return addRequestDelete(service::deleteChangeRecordRefCharc, changeRecordRefCharc);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordRefClass(
        @Nonnull final ChangeRecordRefClass changeRecordRefClass )
    {
        return addRequestCreate(service::createChangeRecordRefClass, changeRecordRefClass);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordRefClass(
        @Nonnull final ChangeRecordRefClass changeRecordRefClass )
    {
        return addRequestUpdate(service::updateChangeRecordRefClass, changeRecordRefClass);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordRefClass(
        @Nonnull final ChangeRecordRefClass changeRecordRefClass )
    {
        return addRequestDelete(service::deleteChangeRecordRefClass, changeRecordRefClass);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordReferenceBit(
        @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit )
    {
        return addRequestCreate(service::createChangeRecordReferenceBit, changeRecordReferenceBit);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordReferenceBit(
        @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit )
    {
        return addRequestUpdate(service::updateChangeRecordReferenceBit, changeRecordReferenceBit);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordReferenceBit(
        @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit )
    {
        return addRequestDelete(service::deleteChangeRecordReferenceBit, changeRecordReferenceBit);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordReferenceBOM(
        @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM )
    {
        return addRequestCreate(service::createChangeRecordReferenceBOM, changeRecordReferenceBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordReferenceBOM(
        @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM )
    {
        return addRequestUpdate(service::updateChangeRecordReferenceBOM, changeRecordReferenceBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordReferenceBOM(
        @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM )
    {
        return addRequestDelete(service::deleteChangeRecordReferenceBOM, changeRecordReferenceBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordReferenceDoc(
        @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc )
    {
        return addRequestCreate(service::createChangeRecordReferenceDoc, changeRecordReferenceDoc);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordReferenceDoc(
        @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc )
    {
        return addRequestUpdate(service::updateChangeRecordReferenceDoc, changeRecordReferenceDoc);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordReferenceDoc(
        @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc )
    {
        return addRequestDelete(service::deleteChangeRecordReferenceDoc, changeRecordReferenceDoc);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordReferenceMat(
        @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat )
    {
        return addRequestCreate(service::createChangeRecordReferenceMat, changeRecordReferenceMat);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordReferenceMat(
        @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat )
    {
        return addRequestUpdate(service::updateChangeRecordReferenceMat, changeRecordReferenceMat);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordReferenceMat(
        @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat )
    {
        return addRequestDelete(service::deleteChangeRecordReferenceMat, changeRecordReferenceMat);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordReferencePSV(
        @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV )
    {
        return addRequestCreate(service::createChangeRecordReferencePSV, changeRecordReferencePSV);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordReferencePSV(
        @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV )
    {
        return addRequestUpdate(service::updateChangeRecordReferencePSV, changeRecordReferencePSV);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordReferencePSV(
        @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV )
    {
        return addRequestDelete(service::deleteChangeRecordReferencePSV, changeRecordReferencePSV);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordRefMasterRecipe(
        @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe )
    {
        return addRequestCreate(service::createChangeRecordRefMasterRecipe, changeRecordRefMasterRecipe);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordRefMasterRecipe(
        @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe )
    {
        return addRequestUpdate(service::updateChangeRecordRefMasterRecipe, changeRecordRefMasterRecipe);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordRefMasterRecipe(
        @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe )
    {
        return addRequestDelete(service::deleteChangeRecordRefMasterRecipe, changeRecordRefMasterRecipe);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChangeRecordRefProdnRouting(
        @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting )
    {
        return addRequestCreate(service::createChangeRecordRefProdnRouting, changeRecordRefProdnRouting);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChangeRecordRefProdnRouting(
        @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting )
    {
        return addRequestUpdate(service::updateChangeRecordRefProdnRouting, changeRecordRefProdnRouting);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChangeRecordRefProdnRouting(
        @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting )
    {
        return addRequestDelete(service::deleteChangeRecordRefProdnRouting, changeRecordRefProdnRouting);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM )
    {
        return addRequestCreate(service::createChgRecdEquipBOM, chgRecdEquipBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM )
    {
        return addRequestUpdate(service::updateChgRecdEquipBOM, chgRecdEquipBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM )
    {
        return addRequestDelete(service::deleteChgRecdEquipBOM, chgRecdEquipBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdFuncLocBOM(
        @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM )
    {
        return addRequestCreate(service::createChgRecdFuncLocBOM, chgRecdFuncLocBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdFuncLocBOM(
        @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM )
    {
        return addRequestUpdate(service::updateChgRecdFuncLocBOM, chgRecdFuncLocBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdFuncLocBOM(
        @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM )
    {
        return addRequestDelete(service::deleteChgRecdFuncLocBOM, chgRecdFuncLocBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdFuncLocTskList(
        @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList )
    {
        return addRequestCreate(service::createChgRecdFuncLocTskList, chgRecdFuncLocTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdFuncLocTskList(
        @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList )
    {
        return addRequestUpdate(service::updateChgRecdFuncLocTskList, chgRecdFuncLocTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdFuncLocTskList(
        @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList )
    {
        return addRequestDelete(service::deleteChgRecdFuncLocTskList, chgRecdFuncLocTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdObjPgMaintTskList(
        @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList )
    {
        return addRequestCreate(service::createChgRecdObjPgMaintTskList, chgRecdObjPgMaintTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdObjPgMaintTskList(
        @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList )
    {
        return addRequestUpdate(service::updateChgRecdObjPgMaintTskList, chgRecdObjPgMaintTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdObjPgMaintTskList(
        @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList )
    {
        return addRequestDelete(service::deleteChgRecdObjPgMaintTskList, chgRecdObjPgMaintTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdPLMEPDCollabn(
        @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn )
    {
        return addRequestCreate(service::createChgRecdPLMEPDCollabn, chgRecdPLMEPDCollabn);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdPLMEPDCollabn(
        @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn )
    {
        return addRequestDelete(service::deleteChgRecdPLMEPDCollabn, chgRecdPLMEPDCollabn);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM )
    {
        return addRequestCreate(service::createChgRecdRefEngBOM, chgRecdRefEngBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM )
    {
        return addRequestUpdate(service::updateChgRecdRefEngBOM, chgRecdRefEngBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM )
    {
        return addRequestDelete(service::deleteChgRecdRefEngBOM, chgRecdRefEngBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdRefEquipTskList(
        @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList )
    {
        return addRequestCreate(service::createChgRecdRefEquipTskList, chgRecdRefEquipTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdRefEquipTskList(
        @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList )
    {
        return addRequestUpdate(service::updateChgRecdRefEquipTskList, chgRecdRefEquipTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdRefEquipTskList(
        @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList )
    {
        return addRequestDelete(service::deleteChgRecdRefEquipTskList, chgRecdRefEquipTskList);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM )
    {
        return addRequestCreate(service::createChgRecdRefMfgBOM, chgRecdRefMfgBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM )
    {
        return addRequestUpdate(service::updateChgRecdRefMfgBOM, chgRecdRefMfgBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM )
    {
        return addRequestDelete(service::deleteChgRecdRefMfgBOM, chgRecdRefMfgBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM )
    {
        return addRequestCreate(service::createChgRecdRefStdBOM, chgRecdRefStdBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM )
    {
        return addRequestUpdate(service::updateChgRecdRefStdBOM, chgRecdRefStdBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM )
    {
        return addRequestDelete(service::deleteChgRecdRefStdBOM, chgRecdRefStdBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet createChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM )
    {
        return addRequestCreate(service::createChgRecdRefVarBOM, chgRecdRefVarBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet updateChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM )
    {
        return addRequestUpdate(service::updateChgRecdRefVarBOM, chgRecdRefVarBOM);
    }

    @Nonnull
    @Override
    public ChangeRecordServiceBatchChangeSet deleteChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM )
    {
        return addRequestDelete(service::deleteChgRecdRefVarBOM, chgRecdRefVarBOM);
    }

}
