/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
 * ChangeRecordReferenceDoc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordReferenceDocField
 * ChangeRecordReferenceDocField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChangeRecordReferenceDocLink
 * ChangeRecordReferenceDocLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#CHANGE_RECORD_REFERENCE_UUID
 * CHANGE_RECORD_REFERENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#CHANGE_RECORD
 * CHANGE_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#CHANGE_RECORD_UUID
 * CHANGE_RECORD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#CHANGE_RECORD_REFERENCE_TYPE
 * CHANGE_RECORD_REFERENCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#DOCUMENT_INFO_RECORD
 * DOCUMENT_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#DOCUMENT_TYPE
 * DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#DOCUMENT_PART
 * DOCUMENT_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#DOCUMENT_VERSION
 * DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#CHANGE_RECORD_ITEM_RELEVANCE
 * CHANGE_RECORD_ITEM_RELEVANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc#EXTERNAL_DOCUMENT_STATUS
 * EXTERNAL_DOCUMENT_STATUS}</li>
 * </ul>
 *
 */
public interface ChangeRecordReferenceDocSelectable extends EntitySelectable<ChangeRecordReferenceDoc>
{

}
