/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
 * ChangeRecordReferenceMat}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordReferenceMatField
 * ChangeRecordReferenceMatField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChangeRecordReferenceMatLink
 * ChangeRecordReferenceMatLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CHANGE_RECORD_REFERENCE_UUID
 * CHANGE_RECORD_REFERENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CHANGE_RECORD
 * CHANGE_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CHANGE_RECORD_UUID
 * CHANGE_RECORD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CHANGE_RECORD_REFERENCE_TYPE
 * CHANGE_RECORD_REFERENCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#MATERIAL_TYPE
 * MATERIAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#MATERIAL_STATUS
 * MATERIAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CHANGE_RECORD_ITEM_RELEVANCE
 * CHANGE_RECORD_ITEM_RELEVANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat#CHANGE_RECORD_ITEM_PROCG_STATUS
 * CHANGE_RECORD_ITEM_PROCG_STATUS}</li>
 * </ul>
 *
 */
public interface ChangeRecordReferenceMatSelectable extends EntitySelectable<ChangeRecordReferenceMat>
{

}
