/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
 * ChangeRecordReferencePSV}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordReferencePSVField
 * ChangeRecordReferencePSVField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChangeRecordReferencePSVLink
 * ChangeRecordReferencePSVLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CHANGE_RECORD_REFERENCE_UUID
 * CHANGE_RECORD_REFERENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CHANGE_RECORD_UUID
 * CHANGE_RECORD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CHANGE_RECORD
 * CHANGE_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CHANGE_RECORD_REFERENCE_TYPE
 * CHANGE_RECORD_REFERENCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CLASS_PROPERTY
 * CLASS_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#PRODUCT_STRUCTURE_NODE_NAME
 * PRODUCT_STRUCTURE_NODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#PROD_STRUC_NODE_DESCRIPTION
 * PROD_STRUC_NODE_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#PRODUCT_STRUCTURE_VARIANT_NAME
 * PRODUCT_STRUCTURE_VARIANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#PROD_STRUC_VARIANT_DESCRIPTION
 * PROD_STRUC_VARIANT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#PROD_STRUC_VARIANT_CHANGE_NUMBER
 * PROD_STRUC_VARIANT_CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CHANGE_RECORD_ITEM_RELEVANCE
 * CHANGE_RECORD_ITEM_RELEVANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV#CHANGE_RECORD_REF_OBJECT_UUID
 * CHANGE_RECORD_REF_OBJECT_UUID}</li>
 * </ul>
 *
 */
public interface ChangeRecordReferencePSVSelectable extends EntitySelectable<ChangeRecordReferencePSV>
{

}
