/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordField
 * ChangeRecordField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChangeRecordLink
 * ChangeRecordLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#UPDATE_MC UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_FUNC_LOC_TSK_LIST_OC
 * CHANGE_RECORD_FUNC_LOC_TSK_LIST_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_RATE_RTG_TSK_LIST_OC
 * CHANGE_RECORD_RATE_RTG_TSK_LIST_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_CHARC_OC
 * CHANGE_RECORD_REF_CHARC_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_CLASS_OC
 * CHANGE_RECORD_REF_CLASS_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_EQUIP_TSK_LIST_OC
 * CHANGE_RECORD_REF_EQUIP_TSK_LIST_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_INSP_PLAN_OC
 * CHANGE_RECORD_REF_INSP_PLAN_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_LABEL_SET_OC
 * CHANGE_RECORD_REF_LABEL_SET_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_MASTER_RECIPE_OC
 * CHANGE_RECORD_REF_MASTER_RECIPE_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_OP_SET_TSK_LIST_OC
 * CHANGE_RECORD_REF_OP_SET_TSK_LIST_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_PRODN_ROUTING_OC
 * CHANGE_RECORD_REF_PRODN_ROUTING_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_RECIPE_OC
 * CHANGE_RECORD_REF_RECIPE_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_SPECIFICATION_OC
 * CHANGE_RECORD_REF_SPECIFICATION_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_STD_BOM_OC
 * CHANGE_RECORD_REF_STD_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_TMPL_ROUTING_OC
 * CHANGE_RECORD_REF_TMPL_ROUTING_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_REF_VAR_BOM_OC
 * CHANGE_RECORD_REF_VAR_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_COLLABORATION_OC
 * CHG_RECD_COLLABORATION_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_EQUIP_BOM_OC
 * CHG_RECD_EQUIP_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_FUNC_LOC_BOM_OC
 * CHG_RECD_FUNC_LOC_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_REF_CUT_PLNG_PRFL_TSK_LIST_OC
 * CHG_RECD_REF_CUT_PLNG_PRFL_TSK_LIST_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_REF_ENG_BOM_OC
 * CHG_RECD_REF_ENG_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_REF_MAINT_TSK_LIST_OC
 * CHG_RECD_REF_MAINT_TSK_LIST_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_REF_MFG_BOM_OC
 * CHG_RECD_REF_MFG_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_REF_PLNG_SCP_OC
 * CHG_RECD_REF_PLNG_SCP_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_REF_RATE_RTG_TSK_LIST_OC
 * CHG_RECD_REF_RATE_RTG_TSK_LIST_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_WBS_ELMNT_BOM_OC
 * CHG_RECD_WBS_ELMNT_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#REF_BIT_OC REF_BIT_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#REF_BOM_OC REF_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#REF_DOC_OC REF_DOC_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#REF_MAT_OC REF_MAT_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#REF_PSV_OC REF_PSV_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_UUID
 * CHANGE_RECORD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD
 * CHANGE_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_TYPE
 * CHANGE_RECORD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_STATUS
 * CHANGE_RECORD_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_LIFECYCLE_STATUS
 * CHANGE_RECORD_LIFECYCLE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#PARTNER PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECORD_DESCRIPTION_TEXT
 * CHG_RECORD_DESCRIPTION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHANGE_RECORD_DETAIL_DESCRIPTION
 * CHANGE_RECORD_DETAIL_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#CHG_RECD_EXPECTED_COMPLETION_DATE
 * CHG_RECD_EXPECTED_COMPLETION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_FUNC_LOC_TSK_LIST
 * TO_CHANGE_RECORD_FUNC_LOC_TSK_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_REF_CHARC
 * TO_CHANGE_RECORD_REF_CHARC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_REF_CLASS
 * TO_CHANGE_RECORD_REF_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_REF_EQUIP_TSK_LIST
 * TO_CHANGE_RECORD_REF_EQUIP_TSK_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_REF_MASTER_RECIPE
 * TO_CHANGE_RECORD_REF_MASTER_RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_REF_PRODN_ROUTING
 * TO_CHANGE_RECORD_REF_PRODN_ROUTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_REF_STD_BOM
 * TO_CHANGE_RECORD_REF_STD_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHANGE_RECORD_REF_VAR_BOM
 * TO_CHANGE_RECORD_REF_VAR_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHG_RECD_COLLABORATION
 * TO_CHG_RECD_COLLABORATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHG_RECD_EQUIP_BOM
 * TO_CHG_RECD_EQUIP_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHG_RECD_FUNC_LOC_BOM
 * TO_CHG_RECD_FUNC_LOC_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHG_RECD_REF_ENG_BOM
 * TO_CHG_RECD_REF_ENG_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHG_RECD_REF_MAINT_TSK_LIST
 * TO_CHG_RECD_REF_MAINT_TSK_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_CHG_RECD_REF_MFG_BOM
 * TO_CHG_RECD_REF_MFG_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_REF_BIT TO_REF_BIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_REF_BOM TO_REF_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_REF_DOC TO_REF_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_REF_MAT TO_REF_MAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord#TO_REF_PSV TO_REF_PSV}</li>
 * </ul>
 *
 */
public interface ChangeRecordSelectable extends EntitySelectable<ChangeRecord>
{

}
