/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM ChgRecdEquipBOM}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChgRecdEquipBOMField
 * ChgRecdEquipBOMField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChgRecdEquipBOMLink
 * ChgRecdEquipBOMLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#DELETE_MC DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#UPDATE_MC UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_REFERENCE_UUID
 * CHANGE_RECORD_REFERENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD
 * CHANGE_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_UUID
 * CHANGE_RECORD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_REFERENCE_TYPE
 * CHANGE_RECORD_REFERENCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_REFERENCE_SUBTYPE
 * CHANGE_RECORD_REFERENCE_SUBTYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_REFERENCE
 * CHANGE_RECORD_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#PARENT_CHANGE_RECORD_REF_UUID
 * PARENT_CHANGE_RECORD_REF_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#IS_MAIN_REFERENCE
 * IS_MAIN_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_ITEM_RELEVANCE
 * CHANGE_RECORD_ITEM_RELEVANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_VIRTUAL_REF_IND
 * CHANGE_RECORD_VIRTUAL_REF_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_REF_OBJECT_UUID
 * CHANGE_RECORD_REF_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM#CHANGE_RECORD_ITEM_PROCG_STATUS
 * CHANGE_RECORD_ITEM_PROCG_STATUS}</li>
 * </ul>
 *
 */
public interface ChgRecdEquipBOMSelectable extends EntitySelectable<ChgRecdEquipBOM>
{

}
