/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
 * ChgRecdObjPgMaintTskList}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChgRecdObjPgMaintTskListField
 * ChgRecdObjPgMaintTskListField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChgRecdObjPgMaintTskListLink
 * ChgRecdObjPgMaintTskListLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#CHANGE_RECORD_REFERENCE_UUID
 * CHANGE_RECORD_REFERENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#CHANGE_RECORD
 * CHANGE_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#CHANGE_RECORD_UUID
 * CHANGE_RECORD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#REF_MAINT_TSK_LIST_GROUP
 * REF_MAINT_TSK_LIST_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#REF_MAINT_TSK_LIST
 * REF_MAINT_TSK_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#CHANGE_RECORD_ITEM_RELEVANCE
 * CHANGE_RECORD_ITEM_RELEVANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#CHANGE_RECORD_ITEM_PROCG_STATUS
 * CHANGE_RECORD_ITEM_PROCG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ChgRecdObjPgMaintTskListSelectable extends EntitySelectable<ChgRecdObjPgMaintTskList>
{

}
