/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn ChgRecdPLMEPDCollabn}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChgRecdPLMEPDCollabnField
 * ChgRecdPLMEPDCollabnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChgRecdPLMEPDCollabnLink
 * ChgRecdPLMEPDCollabnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#CHG_RECD_PLMEPD_COLLABN_UUID
 * CHG_RECD_PLMEPD_COLLABN_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#CHANGE_RECORD_UUID
 * CHANGE_RECORD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#CHG_RECD_PLMEPD_COLLABN_TYPE
 * CHG_RECD_PLMEPD_COLLABN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#CHG_RECD_PLMEPD_COLLABN_SOURCE_ID
 * CHG_RECD_PLMEPD_COLLABN_SOURCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn#CHG_RECD_PLMEPD_COLLABN_ID
 * CHG_RECD_PLMEPD_COLLABN_ID}</li>
 * </ul>
 *
 */
public interface ChgRecdPLMEPDCollabnSelectable extends EntitySelectable<ChgRecdPLMEPDCollabn>
{

}
