/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.field.CharcAttribSeldCodeSetField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldCodeSetSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Characteristic Attribute Selected Sets
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CharcAttribSeldCodeSetType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CharcAttribSeldCodeSet extends VdmEntity<CharcAttribSeldCodeSet>
{

    /**
     * Selector for all available fields of CharcAttribSeldCodeSet.
     *
     */
    public final static CharcAttribSeldCodeSetSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static CharcAttribSeldCodeSetField<String> SELECTED_CODE_SET_PLANT =
        new CharcAttribSeldCodeSetField<String>("SelectedCodeSetPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Selected Set
     */
    @Key
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static CharcAttribSeldCodeSetField<String> SELECTED_CODE_SET =
        new CharcAttribSeldCodeSetField<String>("SelectedCodeSet");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSelectedSetStatus</b>
     * </p>
     *
     * @return Status of Master Record
     */
    @SerializedName( "InspectionSelectedSetStatus" )
    @JsonProperty( "InspectionSelectedSetStatus" )
    @Nullable
    @ODataField( odataName = "InspectionSelectedSetStatus" )
    private String inspectionSelectedSetStatus;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSelectedSetStatus</b> field to query operations.
     *
     */
    public final static CharcAttribSeldCodeSetField<String> INSPECTION_SELECTED_SET_STATUS =
        new CharcAttribSeldCodeSetField<String>("InspectionSelectedSetStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCreatedBy</b>
     * </p>
     *
     * @return Name of User Who Created the Data Record
     */
    @SerializedName( "CharcAttribSeldSetCreatedBy" )
    @JsonProperty( "CharcAttribSeldSetCreatedBy" )
    @Nullable
    @ODataField( odataName = "CharcAttribSeldSetCreatedBy" )
    private String charcAttribSeldSetCreatedBy;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetCreatedBy</b> field to query operations.
     *
     */
    public final static CharcAttribSeldCodeSetField<String> CHARC_ATTRIB_SELD_SET_CREATED_BY =
        new CharcAttribSeldCodeSetField<String>("CharcAttribSeldSetCreatedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCrtedOn</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CharcAttribSeldSetCrtedOn" )
    @JsonProperty( "CharcAttribSeldSetCrtedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcAttribSeldSetCrtedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcAttribSeldSetCrtedOn;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetCrtedOn</b> field to query operations.
     *
     */
    public final static CharcAttribSeldCodeSetField<LocalDateTime> CHARC_ATTRIB_SELD_SET_CRTED_ON =
        new CharcAttribSeldCodeSetField<LocalDateTime>("CharcAttribSeldSetCrtedOn");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetLastChgdBy</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "CharcAttribSeldSetLastChgdBy" )
    @JsonProperty( "CharcAttribSeldSetLastChgdBy" )
    @Nullable
    @ODataField( odataName = "CharcAttribSeldSetLastChgdBy" )
    private String charcAttribSeldSetLastChgdBy;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetLastChgdBy</b> field to query operations.
     *
     */
    public final static CharcAttribSeldCodeSetField<String> CHARC_ATTRIB_SELD_SET_LAST_CHGD_BY =
        new CharcAttribSeldCodeSetField<String>("CharcAttribSeldSetLastChgdBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetLastChgdOn</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "CharcAttribSeldSetLastChgdOn" )
    @JsonProperty( "CharcAttribSeldSetLastChgdOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcAttribSeldSetLastChgdOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcAttribSeldSetLastChgdOn;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetLastChgdOn</b> field to query operations.
     *
     */
    public final static CharcAttribSeldCodeSetField<LocalDateTime> CHARC_ATTRIB_SELD_SET_LAST_CHGD_ON =
        new CharcAttribSeldCodeSetField<LocalDateTime>("CharcAttribSeldSetLastChgdOn");

    @Nonnull
    @Override
    public Class<CharcAttribSeldCodeSet> getType()
    {
        return CharcAttribSeldCodeSet.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Selected Set
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSelectedSetStatus</b>
     * </p>
     *
     * @param inspectionSelectedSetStatus
     *            Status of Master Record
     */
    public void setInspectionSelectedSetStatus( @Nullable final String inspectionSelectedSetStatus )
    {
        rememberChangedField("InspectionSelectedSetStatus", this.inspectionSelectedSetStatus);
        this.inspectionSelectedSetStatus = inspectionSelectedSetStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCreatedBy</b>
     * </p>
     *
     * @param charcAttribSeldSetCreatedBy
     *            Name of User Who Created the Data Record
     */
    public void setCharcAttribSeldSetCreatedBy( @Nullable final String charcAttribSeldSetCreatedBy )
    {
        rememberChangedField("CharcAttribSeldSetCreatedBy", this.charcAttribSeldSetCreatedBy);
        this.charcAttribSeldSetCreatedBy = charcAttribSeldSetCreatedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCrtedOn</b>
     * </p>
     *
     * @param charcAttribSeldSetCrtedOn
     *            System Date on Which Data Record Was Created
     */
    public void setCharcAttribSeldSetCrtedOn( @Nullable final LocalDateTime charcAttribSeldSetCrtedOn )
    {
        rememberChangedField("CharcAttribSeldSetCrtedOn", this.charcAttribSeldSetCrtedOn);
        this.charcAttribSeldSetCrtedOn = charcAttribSeldSetCrtedOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetLastChgdBy</b>
     * </p>
     *
     * @param charcAttribSeldSetLastChgdBy
     *            Name of User Who Last Changed Data Record
     */
    public void setCharcAttribSeldSetLastChgdBy( @Nullable final String charcAttribSeldSetLastChgdBy )
    {
        rememberChangedField("CharcAttribSeldSetLastChgdBy", this.charcAttribSeldSetLastChgdBy);
        this.charcAttribSeldSetLastChgdBy = charcAttribSeldSetLastChgdBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetLastChgdOn</b>
     * </p>
     *
     * @param charcAttribSeldSetLastChgdOn
     *            System Date on Which Data Record Was Changed
     */
    public void setCharcAttribSeldSetLastChgdOn( @Nullable final LocalDateTime charcAttribSeldSetLastChgdOn )
    {
        rememberChangedField("CharcAttribSeldSetLastChgdOn", this.charcAttribSeldSetLastChgdOn);
        this.charcAttribSeldSetLastChgdOn = charcAttribSeldSetLastChgdOn;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CharcAttribSeldCodeSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        result.put("SelectedCodeSet", getSelectedCodeSet());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("InspectionSelectedSetStatus", getInspectionSelectedSetStatus());
        values.put("CharcAttribSeldSetCreatedBy", getCharcAttribSeldSetCreatedBy());
        values.put("CharcAttribSeldSetCrtedOn", getCharcAttribSeldSetCrtedOn());
        values.put("CharcAttribSeldSetLastChgdBy", getCharcAttribSeldSetLastChgdBy());
        values.put("CharcAttribSeldSetLastChgdOn", getCharcAttribSeldSetLastChgdOn());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("InspectionSelectedSetStatus") ) {
                final Object value = values.remove("InspectionSelectedSetStatus");
                if( (value == null) || (!value.equals(getInspectionSelectedSetStatus())) ) {
                    setInspectionSelectedSetStatus(((String) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetCreatedBy") ) {
                final Object value = values.remove("CharcAttribSeldSetCreatedBy");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetCreatedBy())) ) {
                    setCharcAttribSeldSetCreatedBy(((String) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetCrtedOn") ) {
                final Object value = values.remove("CharcAttribSeldSetCrtedOn");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetCrtedOn())) ) {
                    setCharcAttribSeldSetCrtedOn(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetLastChgdBy") ) {
                final Object value = values.remove("CharcAttribSeldSetLastChgdBy");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetLastChgdBy())) ) {
                    setCharcAttribSeldSetLastChgdBy(((String) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetLastChgdOn") ) {
                final Object value = values.remove("CharcAttribSeldSetLastChgdOn");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetLastChgdOn())) ) {
                    setCharcAttribSeldSetLastChgdOn(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CharcAttribSeldCodeSetField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CharcAttribSeldCodeSetField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CharcAttribSeldCodeSetField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CharcAttribSeldCodeSetField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService.DEFAULT_SERVICE_PATH);
    }

}
