/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldCodeSetSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet
 * CharcAttribSeldCodeSet} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CharcAttribSeldCodeSetByKeyFluentHelper
    extends
    FluentHelperByKey<CharcAttribSeldCodeSetByKeyFluentHelper, CharcAttribSeldCodeSet, CharcAttribSeldCodeSetSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet
     * CharcAttribSeldCodeSet} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CharcAttribSeldCodeSet}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CharcAttribSeldCodeSet}
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public CharcAttribSeldCodeSetByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String selectedCodeSetPlant,
        final String selectedCodeSet )
    {
        super(servicePath, entityCollection);
        this.key.put("SelectedCodeSetPlant", selectedCodeSetPlant);
        this.key.put("SelectedCodeSet", selectedCodeSet);
    }

    @Override
    @Nonnull
    protected Class<CharcAttribSeldCodeSet> getEntityClass()
    {
        return CharcAttribSeldCodeSet.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
