/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.field.CharcAttribSeldSetCodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldSetCodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Characteristic Attribute Selected Set Codes and Code Groups
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CharcAttribSeldSetCodeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CharcAttribSeldSetCode extends VdmEntity<CharcAttribSeldSetCode>
{

    /**
     * Selector for all available fields of CharcAttribSeldSetCode.
     *
     */
    public final static CharcAttribSeldSetCodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> SELECTED_CODE_SET_PLANT =
        new CharcAttribSeldSetCodeField<String>("SelectedCodeSetPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Selected Set
     */
    @Key
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> SELECTED_CODE_SET =
        new CharcAttribSeldSetCodeField<String>("SelectedCodeSet");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @return Code Group
     */
    @Key
    @SerializedName( "CharacteristicAttributeCodeGrp" )
    @JsonProperty( "CharacteristicAttributeCodeGrp" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCodeGrp" )
    private String characteristicAttributeCodeGrp;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCodeGrp</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> CHARACTERISTIC_ATTRIBUTE_CODE_GRP =
        new CharcAttribSeldSetCodeField<String>("CharacteristicAttributeCodeGrp");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @return Code
     */
    @Key
    @SerializedName( "CharacteristicAttributeCode" )
    @JsonProperty( "CharacteristicAttributeCode" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCode" )
    private String characteristicAttributeCode;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCode</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> CHARACTERISTIC_ATTRIBUTE_CODE =
        new CharcAttribSeldSetCodeField<String>("CharacteristicAttributeCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttributeValuation</b>
     * </p>
     *
     * @return Code Valuation
     */
    @SerializedName( "CharcAttributeValuation" )
    @JsonProperty( "CharcAttributeValuation" )
    @Nullable
    @ODataField( odataName = "CharcAttributeValuation" )
    private String charcAttributeValuation;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttributeValuation</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> CHARC_ATTRIBUTE_VALUATION =
        new CharcAttribSeldSetCodeField<String>("CharcAttributeValuation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @return Defect Class
     */
    @SerializedName( "DefectClass" )
    @JsonProperty( "DefectClass" )
    @Nullable
    @ODataField( odataName = "DefectClass" )
    private String defectClass;
    /**
     * Use with available fluent helpers to apply the <b>DefectClass</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> DEFECT_CLASS =
        new CharcAttribSeldSetCodeField<String>("DefectClass");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeCrtedBy</b>
     * </p>
     *
     * @return Name of User Who Created the Data Record
     */
    @SerializedName( "CharcAttribSeldSetCodeCrtedBy" )
    @JsonProperty( "CharcAttribSeldSetCodeCrtedBy" )
    @Nullable
    @ODataField( odataName = "CharcAttribSeldSetCodeCrtedBy" )
    private String charcAttribSeldSetCodeCrtedBy;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetCodeCrtedBy</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> CHARC_ATTRIB_SELD_SET_CODE_CRTED_BY =
        new CharcAttribSeldSetCodeField<String>("CharcAttribSeldSetCodeCrtedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeCrtedOn</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CharcAttribSeldSetCodeCrtedOn" )
    @JsonProperty( "CharcAttribSeldSetCodeCrtedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcAttribSeldSetCodeCrtedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcAttribSeldSetCodeCrtedOn;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetCodeCrtedOn</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<LocalDateTime> CHARC_ATTRIB_SELD_SET_CODE_CRTED_ON =
        new CharcAttribSeldSetCodeField<LocalDateTime>("CharcAttribSeldSetCodeCrtedOn");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeChgdBy</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "CharcAttribSeldSetCodeChgdBy" )
    @JsonProperty( "CharcAttribSeldSetCodeChgdBy" )
    @Nullable
    @ODataField( odataName = "CharcAttribSeldSetCodeChgdBy" )
    private String charcAttribSeldSetCodeChgdBy;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetCodeChgdBy</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<String> CHARC_ATTRIB_SELD_SET_CODE_CHGD_BY =
        new CharcAttribSeldSetCodeField<String>("CharcAttribSeldSetCodeChgdBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeChgdOn</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "CharcAttribSeldSetCodeChgdOn" )
    @JsonProperty( "CharcAttribSeldSetCodeChgdOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcAttribSeldSetCodeChgdOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcAttribSeldSetCodeChgdOn;
    /**
     * Use with available fluent helpers to apply the <b>CharcAttribSeldSetCodeChgdOn</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeField<LocalDateTime> CHARC_ATTRIB_SELD_SET_CODE_CHGD_ON =
        new CharcAttribSeldSetCodeField<LocalDateTime>("CharcAttribSeldSetCodeChgdOn");

    @Nonnull
    @Override
    public Class<CharcAttribSeldSetCode> getType()
    {
        return CharcAttribSeldSetCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Selected Set
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @param characteristicAttributeCodeGrp
     *            Code Group
     */
    public void setCharacteristicAttributeCodeGrp( @Nullable final String characteristicAttributeCodeGrp )
    {
        rememberChangedField("CharacteristicAttributeCodeGrp", this.characteristicAttributeCodeGrp);
        this.characteristicAttributeCodeGrp = characteristicAttributeCodeGrp;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @param characteristicAttributeCode
     *            Code
     */
    public void setCharacteristicAttributeCode( @Nullable final String characteristicAttributeCode )
    {
        rememberChangedField("CharacteristicAttributeCode", this.characteristicAttributeCode);
        this.characteristicAttributeCode = characteristicAttributeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttributeValuation</b>
     * </p>
     *
     * @param charcAttributeValuation
     *            Code Valuation
     */
    public void setCharcAttributeValuation( @Nullable final String charcAttributeValuation )
    {
        rememberChangedField("CharcAttributeValuation", this.charcAttributeValuation);
        this.charcAttributeValuation = charcAttributeValuation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @param defectClass
     *            Defect Class
     */
    public void setDefectClass( @Nullable final String defectClass )
    {
        rememberChangedField("DefectClass", this.defectClass);
        this.defectClass = defectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeCrtedBy</b>
     * </p>
     *
     * @param charcAttribSeldSetCodeCrtedBy
     *            Name of User Who Created the Data Record
     */
    public void setCharcAttribSeldSetCodeCrtedBy( @Nullable final String charcAttribSeldSetCodeCrtedBy )
    {
        rememberChangedField("CharcAttribSeldSetCodeCrtedBy", this.charcAttribSeldSetCodeCrtedBy);
        this.charcAttribSeldSetCodeCrtedBy = charcAttribSeldSetCodeCrtedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeCrtedOn</b>
     * </p>
     *
     * @param charcAttribSeldSetCodeCrtedOn
     *            System Date on Which Data Record Was Created
     */
    public void setCharcAttribSeldSetCodeCrtedOn( @Nullable final LocalDateTime charcAttribSeldSetCodeCrtedOn )
    {
        rememberChangedField("CharcAttribSeldSetCodeCrtedOn", this.charcAttribSeldSetCodeCrtedOn);
        this.charcAttribSeldSetCodeCrtedOn = charcAttribSeldSetCodeCrtedOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeChgdBy</b>
     * </p>
     *
     * @param charcAttribSeldSetCodeChgdBy
     *            Name of User Who Last Changed Data Record
     */
    public void setCharcAttribSeldSetCodeChgdBy( @Nullable final String charcAttribSeldSetCodeChgdBy )
    {
        rememberChangedField("CharcAttribSeldSetCodeChgdBy", this.charcAttribSeldSetCodeChgdBy);
        this.charcAttribSeldSetCodeChgdBy = charcAttribSeldSetCodeChgdBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcAttribSeldSetCodeChgdOn</b>
     * </p>
     *
     * @param charcAttribSeldSetCodeChgdOn
     *            System Date on Which Data Record Was Changed
     */
    public void setCharcAttribSeldSetCodeChgdOn( @Nullable final LocalDateTime charcAttribSeldSetCodeChgdOn )
    {
        rememberChangedField("CharcAttribSeldSetCodeChgdOn", this.charcAttribSeldSetCodeChgdOn);
        this.charcAttribSeldSetCodeChgdOn = charcAttribSeldSetCodeChgdOn;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CharcAttribSeldSetCode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        result.put("SelectedCodeSet", getSelectedCodeSet());
        result.put("CharacteristicAttributeCodeGrp", getCharacteristicAttributeCodeGrp());
        result.put("CharacteristicAttributeCode", getCharacteristicAttributeCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("CharacteristicAttributeCodeGrp", getCharacteristicAttributeCodeGrp());
        values.put("CharacteristicAttributeCode", getCharacteristicAttributeCode());
        values.put("CharcAttributeValuation", getCharcAttributeValuation());
        values.put("DefectClass", getDefectClass());
        values.put("CharcAttribSeldSetCodeCrtedBy", getCharcAttribSeldSetCodeCrtedBy());
        values.put("CharcAttribSeldSetCodeCrtedOn", getCharcAttribSeldSetCodeCrtedOn());
        values.put("CharcAttribSeldSetCodeChgdBy", getCharcAttribSeldSetCodeChgdBy());
        values.put("CharcAttribSeldSetCodeChgdOn", getCharcAttribSeldSetCodeChgdOn());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCodeGrp") ) {
                final Object value = values.remove("CharacteristicAttributeCodeGrp");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCodeGrp())) ) {
                    setCharacteristicAttributeCodeGrp(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCode") ) {
                final Object value = values.remove("CharacteristicAttributeCode");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCode())) ) {
                    setCharacteristicAttributeCode(((String) value));
                }
            }
            if( values.containsKey("CharcAttributeValuation") ) {
                final Object value = values.remove("CharcAttributeValuation");
                if( (value == null) || (!value.equals(getCharcAttributeValuation())) ) {
                    setCharcAttributeValuation(((String) value));
                }
            }
            if( values.containsKey("DefectClass") ) {
                final Object value = values.remove("DefectClass");
                if( (value == null) || (!value.equals(getDefectClass())) ) {
                    setDefectClass(((String) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetCodeCrtedBy") ) {
                final Object value = values.remove("CharcAttribSeldSetCodeCrtedBy");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetCodeCrtedBy())) ) {
                    setCharcAttribSeldSetCodeCrtedBy(((String) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetCodeCrtedOn") ) {
                final Object value = values.remove("CharcAttribSeldSetCodeCrtedOn");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetCodeCrtedOn())) ) {
                    setCharcAttribSeldSetCodeCrtedOn(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetCodeChgdBy") ) {
                final Object value = values.remove("CharcAttribSeldSetCodeChgdBy");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetCodeChgdBy())) ) {
                    setCharcAttribSeldSetCodeChgdBy(((String) value));
                }
            }
            if( values.containsKey("CharcAttribSeldSetCodeChgdOn") ) {
                final Object value = values.remove("CharcAttribSeldSetCodeChgdOn");
                if( (value == null) || (!value.equals(getCharcAttribSeldSetCodeChgdOn())) ) {
                    setCharcAttribSeldSetCodeChgdOn(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CharcAttribSeldSetCodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CharcAttribSeldSetCodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CharcAttribSeldSetCodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CharcAttribSeldSetCodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService.DEFAULT_SERVICE_PATH);
    }

}
