/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldSetCodeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode
 * CharcAttribSeldSetCode} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CharcAttribSeldSetCodeByKeyFluentHelper
    extends
    FluentHelperByKey<CharcAttribSeldSetCodeByKeyFluentHelper, CharcAttribSeldSetCode, CharcAttribSeldSetCodeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode
     * CharcAttribSeldSetCode} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CharcAttribSeldSetCode}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CharcAttribSeldSetCode}
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param characteristicAttributeCode
     *            Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param characteristicAttributeCodeGrp
     *            Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public CharcAttribSeldSetCodeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String characteristicAttributeCodeGrp,
        final String characteristicAttributeCode )
    {
        super(servicePath, entityCollection);
        this.key.put("SelectedCodeSetPlant", selectedCodeSetPlant);
        this.key.put("SelectedCodeSet", selectedCodeSet);
        this.key.put("CharacteristicAttributeCodeGrp", characteristicAttributeCodeGrp);
        this.key.put("CharacteristicAttributeCode", characteristicAttributeCode);
    }

    @Override
    @Nonnull
    protected Class<CharcAttribSeldSetCode> getEntityClass()
    {
        return CharcAttribSeldSetCode.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
