/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.field.CharcAttribSeldSetCodeTField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldSetCodeTSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Characteristic Attribute Selected Set Code Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CharcAttribSeldSetCodeTType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CharcAttribSeldSetCodeT extends VdmEntity<CharcAttribSeldSetCodeT>
{

    /**
     * Selector for all available fields of CharcAttribSeldSetCodeT.
     *
     */
    public final static CharcAttribSeldSetCodeTSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeTField<String> SELECTED_CODE_SET_PLANT =
        new CharcAttribSeldSetCodeTField<String>("SelectedCodeSetPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Selected Set
     */
    @Key
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeTField<String> SELECTED_CODE_SET =
        new CharcAttribSeldSetCodeTField<String>("SelectedCodeSet");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @return Code Group
     */
    @Key
    @SerializedName( "CharacteristicAttributeCodeGrp" )
    @JsonProperty( "CharacteristicAttributeCodeGrp" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCodeGrp" )
    private String characteristicAttributeCodeGrp;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCodeGrp</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeTField<String> CHARACTERISTIC_ATTRIBUTE_CODE_GRP =
        new CharcAttribSeldSetCodeTField<String>("CharacteristicAttributeCodeGrp");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @return Code
     */
    @Key
    @SerializedName( "CharacteristicAttributeCode" )
    @JsonProperty( "CharacteristicAttributeCode" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCode" )
    private String characteristicAttributeCode;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCode</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeTField<String> CHARACTERISTIC_ATTRIBUTE_CODE =
        new CharcAttribSeldSetCodeTField<String>("CharacteristicAttributeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeTField<String> LANGUAGE =
        new CharcAttribSeldSetCodeTField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeTxt</b>
     * </p>
     *
     * @return Text for Code
     */
    @SerializedName( "CharacteristicAttributeCodeTxt" )
    @JsonProperty( "CharacteristicAttributeCodeTxt" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCodeTxt" )
    private String characteristicAttributeCodeTxt;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCodeTxt</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetCodeTField<String> CHARACTERISTIC_ATTRIBUTE_CODE_TXT =
        new CharcAttribSeldSetCodeTField<String>("CharacteristicAttributeCodeTxt");

    @Nonnull
    @Override
    public Class<CharcAttribSeldSetCodeT> getType()
    {
        return CharcAttribSeldSetCodeT.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Selected Set
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @param characteristicAttributeCodeGrp
     *            Code Group
     */
    public void setCharacteristicAttributeCodeGrp( @Nullable final String characteristicAttributeCodeGrp )
    {
        rememberChangedField("CharacteristicAttributeCodeGrp", this.characteristicAttributeCodeGrp);
        this.characteristicAttributeCodeGrp = characteristicAttributeCodeGrp;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @param characteristicAttributeCode
     *            Code
     */
    public void setCharacteristicAttributeCode( @Nullable final String characteristicAttributeCode )
    {
        rememberChangedField("CharacteristicAttributeCode", this.characteristicAttributeCode);
        this.characteristicAttributeCode = characteristicAttributeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeTxt</b>
     * </p>
     *
     * @param characteristicAttributeCodeTxt
     *            Text for Code
     */
    public void setCharacteristicAttributeCodeTxt( @Nullable final String characteristicAttributeCodeTxt )
    {
        rememberChangedField("CharacteristicAttributeCodeTxt", this.characteristicAttributeCodeTxt);
        this.characteristicAttributeCodeTxt = characteristicAttributeCodeTxt;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CharcAttribSeldSetCodeT";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        result.put("SelectedCodeSet", getSelectedCodeSet());
        result.put("CharacteristicAttributeCodeGrp", getCharacteristicAttributeCodeGrp());
        result.put("CharacteristicAttributeCode", getCharacteristicAttributeCode());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("CharacteristicAttributeCodeGrp", getCharacteristicAttributeCodeGrp());
        values.put("CharacteristicAttributeCode", getCharacteristicAttributeCode());
        values.put("Language", getLanguage());
        values.put("CharacteristicAttributeCodeTxt", getCharacteristicAttributeCodeTxt());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCodeGrp") ) {
                final Object value = values.remove("CharacteristicAttributeCodeGrp");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCodeGrp())) ) {
                    setCharacteristicAttributeCodeGrp(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCode") ) {
                final Object value = values.remove("CharacteristicAttributeCode");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCode())) ) {
                    setCharacteristicAttributeCode(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCodeTxt") ) {
                final Object value = values.remove("CharacteristicAttributeCodeTxt");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCodeTxt())) ) {
                    setCharacteristicAttributeCodeTxt(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CharcAttribSeldSetCodeTField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CharcAttribSeldSetCodeTField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CharcAttribSeldSetCodeTField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CharcAttribSeldSetCodeTField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService.DEFAULT_SERVICE_PATH);
    }

}
