/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldSetCodeTSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeT
 * CharcAttribSeldSetCodeT} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CharcAttribSeldSetCodeTByKeyFluentHelper
    extends
    FluentHelperByKey<CharcAttribSeldSetCodeTByKeyFluentHelper, CharcAttribSeldSetCodeT, CharcAttribSeldSetCodeTSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeT
     * CharcAttribSeldSetCodeT} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CharcAttribSeldSetCodeT}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CharcAttribSeldSetCodeT}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param characteristicAttributeCode
     *            Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param characteristicAttributeCodeGrp
     *            Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public CharcAttribSeldSetCodeTByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String characteristicAttributeCodeGrp,
        final String characteristicAttributeCode,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("SelectedCodeSetPlant", selectedCodeSetPlant);
        this.key.put("SelectedCodeSet", selectedCodeSet);
        this.key.put("CharacteristicAttributeCodeGrp", characteristicAttributeCodeGrp);
        this.key.put("CharacteristicAttributeCode", characteristicAttributeCode);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<CharcAttribSeldSetCodeT> getEntityClass()
    {
        return CharcAttribSeldSetCodeT.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
