/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.field.CharcAttribSeldSetTField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldSetTSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Characteristic Attribute Selected Set Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CharcAttribSeldSetTType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CharcAttribSeldSetT extends VdmEntity<CharcAttribSeldSetT>
{

    /**
     * Selector for all available fields of CharcAttribSeldSetT.
     *
     */
    public final static CharcAttribSeldSetTSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetTField<String> SELECTED_CODE_SET_PLANT =
        new CharcAttribSeldSetTField<String>("SelectedCodeSetPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Selected Set
     */
    @Key
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetTField<String> SELECTED_CODE_SET =
        new CharcAttribSeldSetTField<String>("SelectedCodeSet");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetTField<String> LANGUAGE = new CharcAttribSeldSetTField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetText</b>
     * </p>
     *
     * @return Text for Selected Set
     */
    @SerializedName( "SelectedCodeSetText" )
    @JsonProperty( "SelectedCodeSetText" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetText" )
    private String selectedCodeSetText;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetText</b> field to query operations.
     *
     */
    public final static CharcAttribSeldSetTField<String> SELECTED_CODE_SET_TEXT =
        new CharcAttribSeldSetTField<String>("SelectedCodeSetText");

    @Nonnull
    @Override
    public Class<CharcAttribSeldSetT> getType()
    {
        return CharcAttribSeldSetT.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Selected Set
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetText</b>
     * </p>
     *
     * @param selectedCodeSetText
     *            Text for Selected Set
     */
    public void setSelectedCodeSetText( @Nullable final String selectedCodeSetText )
    {
        rememberChangedField("SelectedCodeSetText", this.selectedCodeSetText);
        this.selectedCodeSetText = selectedCodeSetText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CharcAttribSeldSetT";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        result.put("SelectedCodeSet", getSelectedCodeSet());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("Language", getLanguage());
        values.put("SelectedCodeSetText", getSelectedCodeSetText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSetText") ) {
                final Object value = values.remove("SelectedCodeSetText");
                if( (value == null) || (!value.equals(getSelectedCodeSetText())) ) {
                    setSelectedCodeSetText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CharcAttribSeldSetTField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CharcAttribSeldSetTField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CharcAttribSeldSetTField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CharcAttribSeldSetTField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService.DEFAULT_SERVICE_PATH);
    }

}
