/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable.CharcAttribSeldSetTSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT
 * CharcAttribSeldSetT} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class CharcAttribSeldSetTByKeyFluentHelper
    extends
    FluentHelperByKey<CharcAttribSeldSetTByKeyFluentHelper, CharcAttribSeldSetT, CharcAttribSeldSetTSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT
     * CharcAttribSeldSetT} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CharcAttribSeldSetT}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CharcAttribSeldSetT}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public CharcAttribSeldSetTByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("SelectedCodeSetPlant", selectedCodeSetPlant);
        this.key.put("SelectedCodeSet", selectedCodeSet);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<CharcAttribSeldSetT> getEntityClass()
    {
        return CharcAttribSeldSetT.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
