/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CharacteristicAttributeCatalogServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService
 * CharacteristicAttributeCatalogService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultCharacteristicAttributeCatalogServiceBatch
    extends
    BatchFluentHelperBasic<CharacteristicAttributeCatalogServiceBatch, CharacteristicAttributeCatalogServiceBatchChangeSet>
    implements
    CharacteristicAttributeCatalogServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCharacteristicAttributeCatalogServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCharacteristicAttributeCatalogServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCharacteristicAttributeCatalogServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCharacteristicAttributeCatalogServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCharacteristicAttributeCatalogServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CharacteristicAttributeCatalogServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCharacteristicAttributeCatalogServiceBatchChangeSet(this, service);
    }

}
