/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CharacteristicAttributeCatalogServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService
 * CharacteristicAttributeCatalogService}.
 *
 */
public class DefaultCharacteristicAttributeCatalogServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CharacteristicAttributeCatalogServiceBatch, CharacteristicAttributeCatalogServiceBatchChangeSet>
    implements
    CharacteristicAttributeCatalogServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService service;

    @SuppressWarnings( "deprecation" )
    DefaultCharacteristicAttributeCatalogServiceBatchChangeSet(
        @Nonnull final DefaultCharacteristicAttributeCatalogServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicAttributeCatalogService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCharacteristicAttributeCatalogServiceBatchChangeSet getThis()
    {
        return this;
    }

}
