/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet
 * CharcAttribSeldCodeSet}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.field.CharcAttribSeldCodeSetField
 * CharcAttribSeldCodeSetField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.link.CharcAttribSeldCodeSetLink
 * CharcAttribSeldCodeSetLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet#SELECTED_CODE_SET
 * SELECTED_CODE_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet#INSPECTION_SELECTED_SET_STATUS
 * INSPECTION_SELECTED_SET_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet#CHARC_ATTRIB_SELD_SET_CREATED_BY
 * CHARC_ATTRIB_SELD_SET_CREATED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet#CHARC_ATTRIB_SELD_SET_CRTED_ON
 * CHARC_ATTRIB_SELD_SET_CRTED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet#CHARC_ATTRIB_SELD_SET_LAST_CHGD_BY
 * CHARC_ATTRIB_SELD_SET_LAST_CHGD_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet#CHARC_ATTRIB_SELD_SET_LAST_CHGD_ON
 * CHARC_ATTRIB_SELD_SET_LAST_CHGD_ON}</li>
 * </ul>
 *
 */
public interface CharcAttribSeldCodeSetSelectable extends EntitySelectable<CharcAttribSeldCodeSet>
{

}
