/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode
 * CharcAttribSeldSetCode}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.field.CharcAttribSeldSetCodeField
 * CharcAttribSeldSetCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.link.CharcAttribSeldSetCodeLink
 * CharcAttribSeldSetCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#SELECTED_CODE_SET
 * SELECTED_CODE_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#CHARACTERISTIC_ATTRIBUTE_CODE_GRP
 * CHARACTERISTIC_ATTRIBUTE_CODE_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#CHARACTERISTIC_ATTRIBUTE_CODE
 * CHARACTERISTIC_ATTRIBUTE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#CHARC_ATTRIBUTE_VALUATION
 * CHARC_ATTRIBUTE_VALUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#DEFECT_CLASS
 * DEFECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#CHARC_ATTRIB_SELD_SET_CODE_CRTED_BY
 * CHARC_ATTRIB_SELD_SET_CODE_CRTED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#CHARC_ATTRIB_SELD_SET_CODE_CRTED_ON
 * CHARC_ATTRIB_SELD_SET_CODE_CRTED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#CHARC_ATTRIB_SELD_SET_CODE_CHGD_BY
 * CHARC_ATTRIB_SELD_SET_CODE_CHGD_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode#CHARC_ATTRIB_SELD_SET_CODE_CHGD_ON
 * CHARC_ATTRIB_SELD_SET_CODE_CHGD_ON}</li>
 * </ul>
 *
 */
public interface CharcAttribSeldSetCodeSelectable extends EntitySelectable<CharcAttribSeldSetCode>
{

}
