/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT
 * CharcAttribSeldSetT}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.field.CharcAttribSeldSetTField
 * CharcAttribSeldSetTField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.link.CharcAttribSeldSetTLink
 * CharcAttribSeldSetTLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT#SELECTED_CODE_SET
 * SELECTED_CODE_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT#SELECTED_CODE_SET_TEXT
 * SELECTED_CODE_SET_TEXT}</li>
 * </ul>
 *
 */
public interface CharcAttribSeldSetTSelectable extends EntitySelectable<CharcAttribSeldSetT>
{

}
