/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.field.ClfnCharacteristicForKeyDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.link.ClfnCharacteristicForKeyDateLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable.ClfnCharacteristicForKeyDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Characteristic Header Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ClfnCharacteristicForKeyDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ClfnCharacteristicForKeyDate extends VdmEntity<ClfnCharacteristicForKeyDate>
{

    /**
     * Selector for all available fields of ClfnCharacteristicForKeyDate.
     *
     */
    public final static ClfnCharacteristicForKeyDateSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> DELETE_MC =
        new ClfnCharacteristicForKeyDateField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> UPDATE_MC =
        new ClfnCharacteristicForKeyDateField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicDesc_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_CharacteristicDesc_oc" )
    @JsonProperty( "to_CharacteristicDesc_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_CharacteristicDesc_oc" )
    private Boolean characteristicDesc_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicDesc_oc</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARACTERISTIC_DESC_OC =
        new ClfnCharacteristicForKeyDateField<Boolean>("to_CharacteristicDesc_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicReference_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_CharacteristicReference_oc" )
    @JsonProperty( "to_CharacteristicReference_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_CharacteristicReference_oc" )
    private Boolean characteristicReference_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicReference_oc</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARACTERISTIC_REFERENCE_OC =
        new ClfnCharacteristicForKeyDateField<Boolean>("to_CharacteristicReference_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicRestriction_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_CharacteristicRestriction_oc" )
    @JsonProperty( "to_CharacteristicRestriction_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_CharacteristicRestriction_oc" )
    private Boolean characteristicRestriction_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicRestriction_oc</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARACTERISTIC_RESTRICTION_OC =
        new ClfnCharacteristicForKeyDateField<Boolean>("to_CharacteristicRestriction_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicValue_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_CharacteristicValue_oc" )
    @JsonProperty( "to_CharacteristicValue_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_CharacteristicValue_oc" )
    private Boolean characteristicValue_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicValue_oc</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARACTERISTIC_VALUE_OC =
        new ClfnCharacteristicForKeyDateField<Boolean>("to_CharacteristicValue_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_INTERNAL_ID =
        new ClfnCharacteristicForKeyDateField<String>("CharcInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARACTERISTIC =
        new ClfnCharacteristicForKeyDateField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcStatus</b>
     * </p>
     *
     * @return Status of a characteristic
     */
    @SerializedName( "CharcStatus" )
    @JsonProperty( "CharcStatus" )
    @Nullable
    @ODataField( odataName = "CharcStatus" )
    private String charcStatus;
    /**
     * Use with available fluent helpers to apply the <b>CharcStatus</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_STATUS =
        new ClfnCharacteristicForKeyDateField<String>("CharcStatus");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CharcStatusName</b>
     * </p>
     *
     * @return Characteristic Status
     */
    @SerializedName( "CharcStatusName" )
    @JsonProperty( "CharcStatusName" )
    @Nullable
    @ODataField( odataName = "CharcStatusName" )
    private String charcStatusName;
    /**
     * Use with available fluent helpers to apply the <b>CharcStatusName</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_STATUS_NAME =
        new ClfnCharacteristicForKeyDateField<String>("CharcStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @return Data type of characteristic
     */
    @SerializedName( "CharcDataType" )
    @JsonProperty( "CharcDataType" )
    @Nullable
    @ODataField( odataName = "CharcDataType" )
    private String charcDataType;
    /**
     * Use with available fluent helpers to apply the <b>CharcDataType</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_DATA_TYPE =
        new ClfnCharacteristicForKeyDateField<String>("CharcDataType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcLength</b>
     * </p>
     *
     * @return Number of Characters
     */
    @SerializedName( "CharcLength" )
    @JsonProperty( "CharcLength" )
    @Nullable
    @ODataField( odataName = "CharcLength" )
    private Short charcLength;
    /**
     * Use with available fluent helpers to apply the <b>CharcLength</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Short> CHARC_LENGTH =
        new ClfnCharacteristicForKeyDateField<Short>("CharcLength");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimals</b>
     * </p>
     *
     * @return Number of Decimal Places
     */
    @SerializedName( "CharcDecimals" )
    @JsonProperty( "CharcDecimals" )
    @Nullable
    @ODataField( odataName = "CharcDecimals" )
    private Short charcDecimals;
    /**
     * Use with available fluent helpers to apply the <b>CharcDecimals</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Short> CHARC_DECIMALS =
        new ClfnCharacteristicForKeyDateField<Short>("CharcDecimals");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcTemplate</b>
     * </p>
     *
     * @return Value with template
     */
    @SerializedName( "CharcTemplate" )
    @JsonProperty( "CharcTemplate" )
    @Nullable
    @ODataField( odataName = "CharcTemplate" )
    private String charcTemplate;
    /**
     * Use with available fluent helpers to apply the <b>CharcTemplate</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_TEMPLATE =
        new ClfnCharacteristicForKeyDateField<String>("CharcTemplate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ValueIsCaseSensitive</b>
     * </p>
     *
     * @return Case Sensitive
     */
    @SerializedName( "ValueIsCaseSensitive" )
    @JsonProperty( "ValueIsCaseSensitive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ValueIsCaseSensitive" )
    private Boolean valueIsCaseSensitive;
    /**
     * Use with available fluent helpers to apply the <b>ValueIsCaseSensitive</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> VALUE_IS_CASE_SENSITIVE =
        new ClfnCharacteristicForKeyDateField<Boolean>("ValueIsCaseSensitive");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcGroup</b>
     * </p>
     *
     * @return Characteristic Group
     */
    @SerializedName( "CharcGroup" )
    @JsonProperty( "CharcGroup" )
    @Nullable
    @ODataField( odataName = "CharcGroup" )
    private String charcGroup;
    /**
     * Use with available fluent helpers to apply the <b>CharcGroup</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_GROUP =
        new ClfnCharacteristicForKeyDateField<String>("CharcGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcGroupName</b>
     * </p>
     *
     * @return Characteristics Group Description
     */
    @SerializedName( "CharcGroupName" )
    @JsonProperty( "CharcGroupName" )
    @Nullable
    @ODataField( odataName = "CharcGroupName" )
    private String charcGroupName;
    /**
     * Use with available fluent helpers to apply the <b>CharcGroupName</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_GROUP_NAME =
        new ClfnCharacteristicForKeyDateField<String>("CharcGroupName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntryIsRequired</b>
     * </p>
     *
     * @return Entry Required
     */
    @SerializedName( "EntryIsRequired" )
    @JsonProperty( "EntryIsRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntryIsRequired" )
    private Boolean entryIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>EntryIsRequired</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> ENTRY_IS_REQUIRED =
        new ClfnCharacteristicForKeyDateField<Boolean>("EntryIsRequired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MultipleValuesAreAllowed</b>
     * </p>
     *
     * @return Multiple Values Are Allowed
     */
    @SerializedName( "MultipleValuesAreAllowed" )
    @JsonProperty( "MultipleValuesAreAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MultipleValuesAreAllowed" )
    private Boolean multipleValuesAreAllowed;
    /**
     * Use with available fluent helpers to apply the <b>MultipleValuesAreAllowed</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> MULTIPLE_VALUES_ARE_ALLOWED =
        new ClfnCharacteristicForKeyDateField<Boolean>("MultipleValuesAreAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcValueUnit" )
    @JsonProperty( "CharcValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcValueUnit" )
    private String charcValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueUnit</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_VALUE_UNIT =
        new ClfnCharacteristicForKeyDateField<String>("CharcValueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "UnitOfMeasureISOCode" )
    @JsonProperty( "UnitOfMeasureISOCode" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureISOCode" )
    private String unitOfMeasureISOCode;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureISOCode</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> UNIT_OF_MEASURE_ISO_CODE =
        new ClfnCharacteristicForKeyDateField<String>("UnitOfMeasureISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CURRENCY =
        new ClfnCharacteristicForKeyDateField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyISOCode</b>
     * </p>
     *
     * @return ISO Currency Code
     */
    @SerializedName( "CurrencyISOCode" )
    @JsonProperty( "CurrencyISOCode" )
    @Nullable
    @ODataField( odataName = "CurrencyISOCode" )
    private String currencyISOCode;
    /**
     * Use with available fluent helpers to apply the <b>CurrencyISOCode</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CURRENCY_ISO_CODE =
        new ClfnCharacteristicForKeyDateField<String>("CurrencyISOCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcExponentValue</b>
     * </p>
     *
     * @return Exponent display
     */
    @SerializedName( "CharcExponentValue" )
    @JsonProperty( "CharcExponentValue" )
    @Nullable
    @ODataField( odataName = "CharcExponentValue" )
    private Short charcExponentValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcExponentValue</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Short> CHARC_EXPONENT_VALUE =
        new ClfnCharacteristicForKeyDateField<Short>("CharcExponentValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ValueIntervalIsAllowed</b>
     * </p>
     *
     * @return Interval Values Allowed
     */
    @SerializedName( "ValueIntervalIsAllowed" )
    @JsonProperty( "ValueIntervalIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ValueIntervalIsAllowed" )
    private Boolean valueIntervalIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>ValueIntervalIsAllowed</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> VALUE_INTERVAL_IS_ALLOWED =
        new ClfnCharacteristicForKeyDateField<Boolean>("ValueIntervalIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueIsAllowed</b>
     * </p>
     *
     * @return Indicator: Additional Values
     */
    @SerializedName( "AdditionalValueIsAllowed" )
    @JsonProperty( "AdditionalValueIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AdditionalValueIsAllowed" )
    private Boolean additionalValueIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalValueIsAllowed</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> ADDITIONAL_VALUE_IS_ALLOWED =
        new ClfnCharacteristicForKeyDateField<Boolean>("AdditionalValueIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NegativeValueIsAllowed</b>
     * </p>
     *
     * @return Value with Plus or Minus Sign
     */
    @SerializedName( "NegativeValueIsAllowed" )
    @JsonProperty( "NegativeValueIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NegativeValueIsAllowed" )
    private Boolean negativeValueIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>NegativeValueIsAllowed</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> NEGATIVE_VALUE_IS_ALLOWED =
        new ClfnCharacteristicForKeyDateField<Boolean>("NegativeValueIsAllowed");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<LocalDateTime> VALIDITY_START_DATE =
        new ClfnCharacteristicForKeyDateField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<LocalDateTime> VALIDITY_END_DATE =
        new ClfnCharacteristicForKeyDateField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHANGE_NUMBER =
        new ClfnCharacteristicForKeyDateField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DocumentType" )
    @JsonProperty( "DocumentType" )
    @Nullable
    @ODataField( odataName = "DocumentType" )
    private String documentType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentType</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> DOCUMENT_TYPE =
        new ClfnCharacteristicForKeyDateField<String>("DocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @SerializedName( "DocNumber" )
    @JsonProperty( "DocNumber" )
    @Nullable
    @ODataField( odataName = "DocNumber" )
    private String docNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocNumber</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> DOC_NUMBER =
        new ClfnCharacteristicForKeyDateField<String>("DocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @SerializedName( "DocumentVersion" )
    @JsonProperty( "DocumentVersion" )
    @Nullable
    @ODataField( odataName = "DocumentVersion" )
    private String documentVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentVersion</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> DOCUMENT_VERSION =
        new ClfnCharacteristicForKeyDateField<String>("DocumentVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @return Document Part
     */
    @SerializedName( "DocumentPart" )
    @JsonProperty( "DocumentPart" )
    @Nullable
    @ODataField( odataName = "DocumentPart" )
    private String documentPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentPart</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> DOCUMENT_PART =
        new ClfnCharacteristicForKeyDateField<String>("DocumentPart");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcMaintAuthGrp</b>
     * </p>
     *
     * @return Authorization Group for Characteristics Maintenance
     */
    @SerializedName( "CharcMaintAuthGrp" )
    @JsonProperty( "CharcMaintAuthGrp" )
    @Nullable
    @ODataField( odataName = "CharcMaintAuthGrp" )
    private String charcMaintAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>CharcMaintAuthGrp</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_MAINT_AUTH_GRP =
        new ClfnCharacteristicForKeyDateField<String>("CharcMaintAuthGrp");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsReadOnly</b>
     * </p>
     *
     * @return No Entry Allowed for Characteristic
     */
    @SerializedName( "CharcIsReadOnly" )
    @JsonProperty( "CharcIsReadOnly" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CharcIsReadOnly" )
    private Boolean charcIsReadOnly;
    /**
     * Use with available fluent helpers to apply the <b>CharcIsReadOnly</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARC_IS_READ_ONLY =
        new ClfnCharacteristicForKeyDateField<Boolean>("CharcIsReadOnly");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsHidden</b>
     * </p>
     *
     * @return Characteristic Not To Be Displayed
     */
    @SerializedName( "CharcIsHidden" )
    @JsonProperty( "CharcIsHidden" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CharcIsHidden" )
    private Boolean charcIsHidden;
    /**
     * Use with available fluent helpers to apply the <b>CharcIsHidden</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARC_IS_HIDDEN =
        new ClfnCharacteristicForKeyDateField<Boolean>("CharcIsHidden");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsRestrictable</b>
     * </p>
     *
     * @return Indicator: restrictable characteristic
     */
    @SerializedName( "CharcIsRestrictable" )
    @JsonProperty( "CharcIsRestrictable" )
    @Nullable
    @ODataField( odataName = "CharcIsRestrictable" )
    private String charcIsRestrictable;
    /**
     * Use with available fluent helpers to apply the <b>CharcIsRestrictable</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_IS_RESTRICTABLE =
        new ClfnCharacteristicForKeyDateField<String>("CharcIsRestrictable");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcExponentFormat</b>
     * </p>
     *
     * @return Exponent Display Format
     */
    @SerializedName( "CharcExponentFormat" )
    @JsonProperty( "CharcExponentFormat" )
    @Nullable
    @ODataField( odataName = "CharcExponentFormat" )
    private String charcExponentFormat;
    /**
     * Use with available fluent helpers to apply the <b>CharcExponentFormat</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<String> CHARC_EXPONENT_FORMAT =
        new ClfnCharacteristicForKeyDateField<String>("CharcExponentFormat");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcEntryIsNotFormatCtrld</b>
     * </p>
     *
     * @return Unformatted Entry Control
     */
    @SerializedName( "CharcEntryIsNotFormatCtrld" )
    @JsonProperty( "CharcEntryIsNotFormatCtrld" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CharcEntryIsNotFormatCtrld" )
    private Boolean charcEntryIsNotFormatCtrld;
    /**
     * Use with available fluent helpers to apply the <b>CharcEntryIsNotFormatCtrld</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARC_ENTRY_IS_NOT_FORMAT_CTRLD =
        new ClfnCharacteristicForKeyDateField<Boolean>("CharcEntryIsNotFormatCtrld");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcTemplateIsDisplayed</b>
     * </p>
     *
     * @return Indicator: Display Template When Assigning Values
     */
    @SerializedName( "CharcTemplateIsDisplayed" )
    @JsonProperty( "CharcTemplateIsDisplayed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CharcTemplateIsDisplayed" )
    private Boolean charcTemplateIsDisplayed;
    /**
     * Use with available fluent helpers to apply the <b>CharcTemplateIsDisplayed</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<Boolean> CHARC_TEMPLATE_IS_DISPLAYED =
        new ClfnCharacteristicForKeyDateField<Boolean>("CharcTemplateIsDisplayed");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<LocalDateTime> CREATION_DATE =
        new ClfnCharacteristicForKeyDateField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<LocalDateTime> LAST_CHANGE_DATE =
        new ClfnCharacteristicForKeyDateField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CharcLastChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CharcLastChangedDateTime" )
    @JsonProperty( "CharcLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime charcLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcLastChangedDateTime</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<ZonedDateTime> CHARC_LAST_CHANGED_DATE_TIME =
        new ClfnCharacteristicForKeyDateField<ZonedDateTime>("CharcLastChangedDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return Date data element for SYST
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateField<LocalDateTime> KEY_DATE =
        new ClfnCharacteristicForKeyDateField<LocalDateTime>("KeyDate");
    /**
     * Navigation property <b>to_CharacteristicDesc</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
     * <b>ClfnCharcDescForKeyDate</b>.
     *
     */
    @SerializedName( "to_CharacteristicDesc" )
    @JsonProperty( "to_CharacteristicDesc" )
    @ODataField( odataName = "to_CharacteristicDesc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnCharcDescForKeyDate> toCharacteristicDesc;
    /**
     * Navigation property <b>to_CharacteristicReference</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
     * <b>ClfnCharcRefForKeyDate</b>.
     *
     */
    @SerializedName( "to_CharacteristicReference" )
    @JsonProperty( "to_CharacteristicReference" )
    @ODataField( odataName = "to_CharacteristicReference" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnCharcRefForKeyDate> toCharacteristicReference;
    /**
     * Navigation property <b>to_CharacteristicRestriction</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
     * <b>ClfnCharcRstrcnForKeyDate</b>.
     *
     */
    @SerializedName( "to_CharacteristicRestriction" )
    @JsonProperty( "to_CharacteristicRestriction" )
    @ODataField( odataName = "to_CharacteristicRestriction" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnCharcRstrcnForKeyDate> toCharacteristicRestriction;
    /**
     * Navigation property <b>to_CharacteristicValue</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
     * <b>ClfnCharcValueForKeyDate</b>.
     *
     */
    @SerializedName( "to_CharacteristicValue" )
    @JsonProperty( "to_CharacteristicValue" )
    @ODataField( odataName = "to_CharacteristicValue" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnCharcValueForKeyDate> toCharacteristicValue;
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicDesc</b> navigation property to query
     * operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateLink<ClfnCharcDescForKeyDate> TO_CHARACTERISTIC_DESC =
        new ClfnCharacteristicForKeyDateLink<ClfnCharcDescForKeyDate>("to_CharacteristicDesc");
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicReference</b> navigation property to query
     * operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateLink<ClfnCharcRefForKeyDate> TO_CHARACTERISTIC_REFERENCE =
        new ClfnCharacteristicForKeyDateLink<ClfnCharcRefForKeyDate>("to_CharacteristicReference");
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicRestriction</b> navigation property to query
     * operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateLink<ClfnCharcRstrcnForKeyDate> TO_CHARACTERISTIC_RESTRICTION =
        new ClfnCharacteristicForKeyDateLink<ClfnCharcRstrcnForKeyDate>("to_CharacteristicRestriction");
    /**
     * Use with available fluent helpers to apply the <b>to_CharacteristicValue</b> navigation property to query
     * operations.
     *
     */
    public final static ClfnCharacteristicForKeyDateLink<ClfnCharcValueForKeyDate> TO_CHARACTERISTIC_VALUE =
        new ClfnCharacteristicForKeyDateLink<ClfnCharcValueForKeyDate>("to_CharacteristicValue");

    @Nonnull
    @Override
    public Class<ClfnCharacteristicForKeyDate> getType()
    {
        return ClfnCharacteristicForKeyDate.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicDesc_oc</b>
     * </p>
     *
     * @param characteristicDesc_oc
     *            Dynamic CbA-Control
     */
    public void setCharacteristicDesc_oc( @Nullable final Boolean characteristicDesc_oc )
    {
        rememberChangedField("to_CharacteristicDesc_oc", this.characteristicDesc_oc);
        this.characteristicDesc_oc = characteristicDesc_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicReference_oc</b>
     * </p>
     *
     * @param characteristicReference_oc
     *            Dynamic CbA-Control
     */
    public void setCharacteristicReference_oc( @Nullable final Boolean characteristicReference_oc )
    {
        rememberChangedField("to_CharacteristicReference_oc", this.characteristicReference_oc);
        this.characteristicReference_oc = characteristicReference_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicRestriction_oc</b>
     * </p>
     *
     * @param characteristicRestriction_oc
     *            Dynamic CbA-Control
     */
    public void setCharacteristicRestriction_oc( @Nullable final Boolean characteristicRestriction_oc )
    {
        rememberChangedField("to_CharacteristicRestriction_oc", this.characteristicRestriction_oc);
        this.characteristicRestriction_oc = characteristicRestriction_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharacteristicValue_oc</b>
     * </p>
     *
     * @param characteristicValue_oc
     *            Dynamic CbA-Control
     */
    public void setCharacteristicValue_oc( @Nullable final Boolean characteristicValue_oc )
    {
        rememberChangedField("to_CharacteristicValue_oc", this.characteristicValue_oc);
        this.characteristicValue_oc = characteristicValue_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcStatus</b>
     * </p>
     *
     * @param charcStatus
     *            Status of a characteristic
     */
    public void setCharcStatus( @Nullable final String charcStatus )
    {
        rememberChangedField("CharcStatus", this.charcStatus);
        this.charcStatus = charcStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CharcStatusName</b>
     * </p>
     *
     * @param charcStatusName
     *            Characteristic Status
     */
    public void setCharcStatusName( @Nullable final String charcStatusName )
    {
        rememberChangedField("CharcStatusName", this.charcStatusName);
        this.charcStatusName = charcStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @param charcDataType
     *            Data type of characteristic
     */
    public void setCharcDataType( @Nullable final String charcDataType )
    {
        rememberChangedField("CharcDataType", this.charcDataType);
        this.charcDataType = charcDataType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcLength</b>
     * </p>
     *
     * @param charcLength
     *            Number of Characters
     */
    public void setCharcLength( @Nullable final Short charcLength )
    {
        rememberChangedField("CharcLength", this.charcLength);
        this.charcLength = charcLength;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimals</b>
     * </p>
     *
     * @param charcDecimals
     *            Number of Decimal Places
     */
    public void setCharcDecimals( @Nullable final Short charcDecimals )
    {
        rememberChangedField("CharcDecimals", this.charcDecimals);
        this.charcDecimals = charcDecimals;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcTemplate</b>
     * </p>
     *
     * @param charcTemplate
     *            Value with template
     */
    public void setCharcTemplate( @Nullable final String charcTemplate )
    {
        rememberChangedField("CharcTemplate", this.charcTemplate);
        this.charcTemplate = charcTemplate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ValueIsCaseSensitive</b>
     * </p>
     *
     * @param valueIsCaseSensitive
     *            Case Sensitive
     */
    public void setValueIsCaseSensitive( @Nullable final Boolean valueIsCaseSensitive )
    {
        rememberChangedField("ValueIsCaseSensitive", this.valueIsCaseSensitive);
        this.valueIsCaseSensitive = valueIsCaseSensitive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcGroup</b>
     * </p>
     *
     * @param charcGroup
     *            Characteristic Group
     */
    public void setCharcGroup( @Nullable final String charcGroup )
    {
        rememberChangedField("CharcGroup", this.charcGroup);
        this.charcGroup = charcGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcGroupName</b>
     * </p>
     *
     * @param charcGroupName
     *            Characteristics Group Description
     */
    public void setCharcGroupName( @Nullable final String charcGroupName )
    {
        rememberChangedField("CharcGroupName", this.charcGroupName);
        this.charcGroupName = charcGroupName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntryIsRequired</b>
     * </p>
     *
     * @param entryIsRequired
     *            Entry Required
     */
    public void setEntryIsRequired( @Nullable final Boolean entryIsRequired )
    {
        rememberChangedField("EntryIsRequired", this.entryIsRequired);
        this.entryIsRequired = entryIsRequired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MultipleValuesAreAllowed</b>
     * </p>
     *
     * @param multipleValuesAreAllowed
     *            Multiple Values Are Allowed
     */
    public void setMultipleValuesAreAllowed( @Nullable final Boolean multipleValuesAreAllowed )
    {
        rememberChangedField("MultipleValuesAreAllowed", this.multipleValuesAreAllowed);
        this.multipleValuesAreAllowed = multipleValuesAreAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     *
     * @param charcValueUnit
     *            Unit of Measurement
     */
    public void setCharcValueUnit( @Nullable final String charcValueUnit )
    {
        rememberChangedField("CharcValueUnit", this.charcValueUnit);
        this.charcValueUnit = charcValueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     *
     * @param unitOfMeasureISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setUnitOfMeasureISOCode( @Nullable final String unitOfMeasureISOCode )
    {
        rememberChangedField("UnitOfMeasureISOCode", this.unitOfMeasureISOCode);
        this.unitOfMeasureISOCode = unitOfMeasureISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyISOCode</b>
     * </p>
     *
     * @param currencyISOCode
     *            ISO Currency Code
     */
    public void setCurrencyISOCode( @Nullable final String currencyISOCode )
    {
        rememberChangedField("CurrencyISOCode", this.currencyISOCode);
        this.currencyISOCode = currencyISOCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcExponentValue</b>
     * </p>
     *
     * @param charcExponentValue
     *            Exponent display
     */
    public void setCharcExponentValue( @Nullable final Short charcExponentValue )
    {
        rememberChangedField("CharcExponentValue", this.charcExponentValue);
        this.charcExponentValue = charcExponentValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ValueIntervalIsAllowed</b>
     * </p>
     *
     * @param valueIntervalIsAllowed
     *            Interval Values Allowed
     */
    public void setValueIntervalIsAllowed( @Nullable final Boolean valueIntervalIsAllowed )
    {
        rememberChangedField("ValueIntervalIsAllowed", this.valueIntervalIsAllowed);
        this.valueIntervalIsAllowed = valueIntervalIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueIsAllowed</b>
     * </p>
     *
     * @param additionalValueIsAllowed
     *            Indicator: Additional Values
     */
    public void setAdditionalValueIsAllowed( @Nullable final Boolean additionalValueIsAllowed )
    {
        rememberChangedField("AdditionalValueIsAllowed", this.additionalValueIsAllowed);
        this.additionalValueIsAllowed = additionalValueIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NegativeValueIsAllowed</b>
     * </p>
     *
     * @param negativeValueIsAllowed
     *            Value with Plus or Minus Sign
     */
    public void setNegativeValueIsAllowed( @Nullable final Boolean negativeValueIsAllowed )
    {
        rememberChangedField("NegativeValueIsAllowed", this.negativeValueIsAllowed);
        this.negativeValueIsAllowed = negativeValueIsAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *            Document Type
     */
    public void setDocumentType( @Nullable final String documentType )
    {
        rememberChangedField("DocumentType", this.documentType);
        this.documentType = documentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @param docNumber
     *            Document number
     */
    public void setDocNumber( @Nullable final String docNumber )
    {
        rememberChangedField("DocNumber", this.docNumber);
        this.docNumber = docNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *            Document Version
     */
    public void setDocumentVersion( @Nullable final String documentVersion )
    {
        rememberChangedField("DocumentVersion", this.documentVersion);
        this.documentVersion = documentVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *            Document Part
     */
    public void setDocumentPart( @Nullable final String documentPart )
    {
        rememberChangedField("DocumentPart", this.documentPart);
        this.documentPart = documentPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcMaintAuthGrp</b>
     * </p>
     *
     * @param charcMaintAuthGrp
     *            Authorization Group for Characteristics Maintenance
     */
    public void setCharcMaintAuthGrp( @Nullable final String charcMaintAuthGrp )
    {
        rememberChangedField("CharcMaintAuthGrp", this.charcMaintAuthGrp);
        this.charcMaintAuthGrp = charcMaintAuthGrp;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsReadOnly</b>
     * </p>
     *
     * @param charcIsReadOnly
     *            No Entry Allowed for Characteristic
     */
    public void setCharcIsReadOnly( @Nullable final Boolean charcIsReadOnly )
    {
        rememberChangedField("CharcIsReadOnly", this.charcIsReadOnly);
        this.charcIsReadOnly = charcIsReadOnly;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsHidden</b>
     * </p>
     *
     * @param charcIsHidden
     *            Characteristic Not To Be Displayed
     */
    public void setCharcIsHidden( @Nullable final Boolean charcIsHidden )
    {
        rememberChangedField("CharcIsHidden", this.charcIsHidden);
        this.charcIsHidden = charcIsHidden;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsRestrictable</b>
     * </p>
     *
     * @param charcIsRestrictable
     *            Indicator: restrictable characteristic
     */
    public void setCharcIsRestrictable( @Nullable final String charcIsRestrictable )
    {
        rememberChangedField("CharcIsRestrictable", this.charcIsRestrictable);
        this.charcIsRestrictable = charcIsRestrictable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcExponentFormat</b>
     * </p>
     *
     * @param charcExponentFormat
     *            Exponent Display Format
     */
    public void setCharcExponentFormat( @Nullable final String charcExponentFormat )
    {
        rememberChangedField("CharcExponentFormat", this.charcExponentFormat);
        this.charcExponentFormat = charcExponentFormat;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcEntryIsNotFormatCtrld</b>
     * </p>
     *
     * @param charcEntryIsNotFormatCtrld
     *            Unformatted Entry Control
     */
    public void setCharcEntryIsNotFormatCtrld( @Nullable final Boolean charcEntryIsNotFormatCtrld )
    {
        rememberChangedField("CharcEntryIsNotFormatCtrld", this.charcEntryIsNotFormatCtrld);
        this.charcEntryIsNotFormatCtrld = charcEntryIsNotFormatCtrld;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcTemplateIsDisplayed</b>
     * </p>
     *
     * @param charcTemplateIsDisplayed
     *            Indicator: Display Template When Assigning Values
     */
    public void setCharcTemplateIsDisplayed( @Nullable final Boolean charcTemplateIsDisplayed )
    {
        rememberChangedField("CharcTemplateIsDisplayed", this.charcTemplateIsDisplayed);
        this.charcTemplateIsDisplayed = charcTemplateIsDisplayed;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CharcLastChangedDateTime</b>
     * </p>
     *
     * @param charcLastChangedDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCharcLastChangedDateTime( @Nullable final ZonedDateTime charcLastChangedDateTime )
    {
        rememberChangedField("CharcLastChangedDateTime", this.charcLastChangedDateTime);
        this.charcLastChangedDateTime = charcLastChangedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            Date data element for SYST
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ClfnCharacteristicForKeyDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CharcInternalID", getCharcInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_CharacteristicDesc_oc", getCharacteristicDesc_oc());
        values.put("to_CharacteristicReference_oc", getCharacteristicReference_oc());
        values.put("to_CharacteristicRestriction_oc", getCharacteristicRestriction_oc());
        values.put("to_CharacteristicValue_oc", getCharacteristicValue_oc());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("Characteristic", getCharacteristic());
        values.put("CharcStatus", getCharcStatus());
        values.put("CharcStatusName", getCharcStatusName());
        values.put("CharcDataType", getCharcDataType());
        values.put("CharcLength", getCharcLength());
        values.put("CharcDecimals", getCharcDecimals());
        values.put("CharcTemplate", getCharcTemplate());
        values.put("ValueIsCaseSensitive", getValueIsCaseSensitive());
        values.put("CharcGroup", getCharcGroup());
        values.put("CharcGroupName", getCharcGroupName());
        values.put("EntryIsRequired", getEntryIsRequired());
        values.put("MultipleValuesAreAllowed", getMultipleValuesAreAllowed());
        values.put("CharcValueUnit", getCharcValueUnit());
        values.put("UnitOfMeasureISOCode", getUnitOfMeasureISOCode());
        values.put("Currency", getCurrency());
        values.put("CurrencyISOCode", getCurrencyISOCode());
        values.put("CharcExponentValue", getCharcExponentValue());
        values.put("ValueIntervalIsAllowed", getValueIntervalIsAllowed());
        values.put("AdditionalValueIsAllowed", getAdditionalValueIsAllowed());
        values.put("NegativeValueIsAllowed", getNegativeValueIsAllowed());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("DocumentType", getDocumentType());
        values.put("DocNumber", getDocNumber());
        values.put("DocumentVersion", getDocumentVersion());
        values.put("DocumentPart", getDocumentPart());
        values.put("CharcMaintAuthGrp", getCharcMaintAuthGrp());
        values.put("CharcIsReadOnly", getCharcIsReadOnly());
        values.put("CharcIsHidden", getCharcIsHidden());
        values.put("CharcIsRestrictable", getCharcIsRestrictable());
        values.put("CharcExponentFormat", getCharcExponentFormat());
        values.put("CharcEntryIsNotFormatCtrld", getCharcEntryIsNotFormatCtrld());
        values.put("CharcTemplateIsDisplayed", getCharcTemplateIsDisplayed());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("CharcLastChangedDateTime", getCharcLastChangedDateTime());
        values.put("KeyDate", getKeyDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_CharacteristicDesc_oc") ) {
                final Object value = values.remove("to_CharacteristicDesc_oc");
                if( (value == null) || (!value.equals(getCharacteristicDesc_oc())) ) {
                    setCharacteristicDesc_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_CharacteristicReference_oc") ) {
                final Object value = values.remove("to_CharacteristicReference_oc");
                if( (value == null) || (!value.equals(getCharacteristicReference_oc())) ) {
                    setCharacteristicReference_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_CharacteristicRestriction_oc") ) {
                final Object value = values.remove("to_CharacteristicRestriction_oc");
                if( (value == null) || (!value.equals(getCharacteristicRestriction_oc())) ) {
                    setCharacteristicRestriction_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_CharacteristicValue_oc") ) {
                final Object value = values.remove("to_CharacteristicValue_oc");
                if( (value == null) || (!value.equals(getCharacteristicValue_oc())) ) {
                    setCharacteristicValue_oc(((Boolean) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharcStatus") ) {
                final Object value = values.remove("CharcStatus");
                if( (value == null) || (!value.equals(getCharcStatus())) ) {
                    setCharcStatus(((String) value));
                }
            }
            if( values.containsKey("CharcStatusName") ) {
                final Object value = values.remove("CharcStatusName");
                if( (value == null) || (!value.equals(getCharcStatusName())) ) {
                    setCharcStatusName(((String) value));
                }
            }
            if( values.containsKey("CharcDataType") ) {
                final Object value = values.remove("CharcDataType");
                if( (value == null) || (!value.equals(getCharcDataType())) ) {
                    setCharcDataType(((String) value));
                }
            }
            if( values.containsKey("CharcLength") ) {
                final Object value = values.remove("CharcLength");
                if( (value == null) || (!value.equals(getCharcLength())) ) {
                    setCharcLength(((Short) value));
                }
            }
            if( values.containsKey("CharcDecimals") ) {
                final Object value = values.remove("CharcDecimals");
                if( (value == null) || (!value.equals(getCharcDecimals())) ) {
                    setCharcDecimals(((Short) value));
                }
            }
            if( values.containsKey("CharcTemplate") ) {
                final Object value = values.remove("CharcTemplate");
                if( (value == null) || (!value.equals(getCharcTemplate())) ) {
                    setCharcTemplate(((String) value));
                }
            }
            if( values.containsKey("ValueIsCaseSensitive") ) {
                final Object value = values.remove("ValueIsCaseSensitive");
                if( (value == null) || (!value.equals(getValueIsCaseSensitive())) ) {
                    setValueIsCaseSensitive(((Boolean) value));
                }
            }
            if( values.containsKey("CharcGroup") ) {
                final Object value = values.remove("CharcGroup");
                if( (value == null) || (!value.equals(getCharcGroup())) ) {
                    setCharcGroup(((String) value));
                }
            }
            if( values.containsKey("CharcGroupName") ) {
                final Object value = values.remove("CharcGroupName");
                if( (value == null) || (!value.equals(getCharcGroupName())) ) {
                    setCharcGroupName(((String) value));
                }
            }
            if( values.containsKey("EntryIsRequired") ) {
                final Object value = values.remove("EntryIsRequired");
                if( (value == null) || (!value.equals(getEntryIsRequired())) ) {
                    setEntryIsRequired(((Boolean) value));
                }
            }
            if( values.containsKey("MultipleValuesAreAllowed") ) {
                final Object value = values.remove("MultipleValuesAreAllowed");
                if( (value == null) || (!value.equals(getMultipleValuesAreAllowed())) ) {
                    setMultipleValuesAreAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("CharcValueUnit") ) {
                final Object value = values.remove("CharcValueUnit");
                if( (value == null) || (!value.equals(getCharcValueUnit())) ) {
                    setCharcValueUnit(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureISOCode") ) {
                final Object value = values.remove("UnitOfMeasureISOCode");
                if( (value == null) || (!value.equals(getUnitOfMeasureISOCode())) ) {
                    setUnitOfMeasureISOCode(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("CurrencyISOCode") ) {
                final Object value = values.remove("CurrencyISOCode");
                if( (value == null) || (!value.equals(getCurrencyISOCode())) ) {
                    setCurrencyISOCode(((String) value));
                }
            }
            if( values.containsKey("CharcExponentValue") ) {
                final Object value = values.remove("CharcExponentValue");
                if( (value == null) || (!value.equals(getCharcExponentValue())) ) {
                    setCharcExponentValue(((Short) value));
                }
            }
            if( values.containsKey("ValueIntervalIsAllowed") ) {
                final Object value = values.remove("ValueIntervalIsAllowed");
                if( (value == null) || (!value.equals(getValueIntervalIsAllowed())) ) {
                    setValueIntervalIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("AdditionalValueIsAllowed") ) {
                final Object value = values.remove("AdditionalValueIsAllowed");
                if( (value == null) || (!value.equals(getAdditionalValueIsAllowed())) ) {
                    setAdditionalValueIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("NegativeValueIsAllowed") ) {
                final Object value = values.remove("NegativeValueIsAllowed");
                if( (value == null) || (!value.equals(getNegativeValueIsAllowed())) ) {
                    setNegativeValueIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentType") ) {
                final Object value = values.remove("DocumentType");
                if( (value == null) || (!value.equals(getDocumentType())) ) {
                    setDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocNumber") ) {
                final Object value = values.remove("DocNumber");
                if( (value == null) || (!value.equals(getDocNumber())) ) {
                    setDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentVersion") ) {
                final Object value = values.remove("DocumentVersion");
                if( (value == null) || (!value.equals(getDocumentVersion())) ) {
                    setDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentPart") ) {
                final Object value = values.remove("DocumentPart");
                if( (value == null) || (!value.equals(getDocumentPart())) ) {
                    setDocumentPart(((String) value));
                }
            }
            if( values.containsKey("CharcMaintAuthGrp") ) {
                final Object value = values.remove("CharcMaintAuthGrp");
                if( (value == null) || (!value.equals(getCharcMaintAuthGrp())) ) {
                    setCharcMaintAuthGrp(((String) value));
                }
            }
            if( values.containsKey("CharcIsReadOnly") ) {
                final Object value = values.remove("CharcIsReadOnly");
                if( (value == null) || (!value.equals(getCharcIsReadOnly())) ) {
                    setCharcIsReadOnly(((Boolean) value));
                }
            }
            if( values.containsKey("CharcIsHidden") ) {
                final Object value = values.remove("CharcIsHidden");
                if( (value == null) || (!value.equals(getCharcIsHidden())) ) {
                    setCharcIsHidden(((Boolean) value));
                }
            }
            if( values.containsKey("CharcIsRestrictable") ) {
                final Object value = values.remove("CharcIsRestrictable");
                if( (value == null) || (!value.equals(getCharcIsRestrictable())) ) {
                    setCharcIsRestrictable(((String) value));
                }
            }
            if( values.containsKey("CharcExponentFormat") ) {
                final Object value = values.remove("CharcExponentFormat");
                if( (value == null) || (!value.equals(getCharcExponentFormat())) ) {
                    setCharcExponentFormat(((String) value));
                }
            }
            if( values.containsKey("CharcEntryIsNotFormatCtrld") ) {
                final Object value = values.remove("CharcEntryIsNotFormatCtrld");
                if( (value == null) || (!value.equals(getCharcEntryIsNotFormatCtrld())) ) {
                    setCharcEntryIsNotFormatCtrld(((Boolean) value));
                }
            }
            if( values.containsKey("CharcTemplateIsDisplayed") ) {
                final Object value = values.remove("CharcTemplateIsDisplayed");
                if( (value == null) || (!value.equals(getCharcTemplateIsDisplayed())) ) {
                    setCharcTemplateIsDisplayed(((Boolean) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcLastChangedDateTime") ) {
                final Object value = values.remove("CharcLastChangedDateTime");
                if( (value == null) || (!value.equals(getCharcLastChangedDateTime())) ) {
                    setCharcLastChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CharacteristicDesc") ) {
                final Object value = (values).remove("to_CharacteristicDesc");
                if( value instanceof Iterable ) {
                    if( toCharacteristicDesc == null ) {
                        toCharacteristicDesc = Lists.newArrayList();
                    } else {
                        toCharacteristicDesc = Lists.newArrayList(toCharacteristicDesc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnCharcDescForKeyDate entity;
                        if( toCharacteristicDesc.size() > i ) {
                            entity = toCharacteristicDesc.get(i);
                        } else {
                            entity = new ClfnCharcDescForKeyDate();
                            toCharacteristicDesc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CharacteristicReference") ) {
                final Object value = (values).remove("to_CharacteristicReference");
                if( value instanceof Iterable ) {
                    if( toCharacteristicReference == null ) {
                        toCharacteristicReference = Lists.newArrayList();
                    } else {
                        toCharacteristicReference = Lists.newArrayList(toCharacteristicReference);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnCharcRefForKeyDate entity;
                        if( toCharacteristicReference.size() > i ) {
                            entity = toCharacteristicReference.get(i);
                        } else {
                            entity = new ClfnCharcRefForKeyDate();
                            toCharacteristicReference.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CharacteristicRestriction") ) {
                final Object value = (values).remove("to_CharacteristicRestriction");
                if( value instanceof Iterable ) {
                    if( toCharacteristicRestriction == null ) {
                        toCharacteristicRestriction = Lists.newArrayList();
                    } else {
                        toCharacteristicRestriction = Lists.newArrayList(toCharacteristicRestriction);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnCharcRstrcnForKeyDate entity;
                        if( toCharacteristicRestriction.size() > i ) {
                            entity = toCharacteristicRestriction.get(i);
                        } else {
                            entity = new ClfnCharcRstrcnForKeyDate();
                            toCharacteristicRestriction.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CharacteristicValue") ) {
                final Object value = (values).remove("to_CharacteristicValue");
                if( value instanceof Iterable ) {
                    if( toCharacteristicValue == null ) {
                        toCharacteristicValue = Lists.newArrayList();
                    } else {
                        toCharacteristicValue = Lists.newArrayList(toCharacteristicValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnCharcValueForKeyDate entity;
                        if( toCharacteristicValue.size() > i ) {
                            entity = toCharacteristicValue.get(i);
                        } else {
                            entity = new ClfnCharcValueForKeyDate();
                            toCharacteristicValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ClfnCharacteristicForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ClfnCharacteristicForKeyDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ClfnCharacteristicForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ClfnCharacteristicForKeyDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCharacteristicDesc != null ) {
            (values).put("to_CharacteristicDesc", toCharacteristicDesc);
        }
        if( toCharacteristicReference != null ) {
            (values).put("to_CharacteristicReference", toCharacteristicReference);
        }
        if( toCharacteristicRestriction != null ) {
            (values).put("to_CharacteristicRestriction", toCharacteristicRestriction);
        }
        if( toCharacteristicValue != null ) {
            (values).put("to_CharacteristicValue", toCharacteristicValue);
        }
        return values;
    }

    /**
     * Fetches the <b>ClfnCharcDescForKeyDate</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CharacteristicDesc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnCharcDescForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcDescForKeyDate> fetchCharacteristicDesc()
    {
        return fetchFieldAsList("to_CharacteristicDesc", ClfnCharcDescForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnCharcDescForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicDesc</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicDesc</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnCharcDescForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcDescForKeyDate> getCharacteristicDescOrFetch()
    {
        if( toCharacteristicDesc == null ) {
            toCharacteristicDesc = fetchCharacteristicDesc();
        }
        return toCharacteristicDesc;
    }

    /**
     * Retrieval of associated <b>ClfnCharcDescForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicDesc</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnCharacteristicForKeyDate</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CharacteristicDesc</b> is already loaded, the result
     *         will contain the <b>ClfnCharcDescForKeyDate</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnCharcDescForKeyDate>> getCharacteristicDescIfPresent()
    {
        return Option.of(toCharacteristicDesc);
    }

    /**
     * Overwrites the list of associated <b>ClfnCharcDescForKeyDate</b> entities for the loaded navigation property
     * <b>to_CharacteristicDesc</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicDesc</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnCharcDescForKeyDate</b> entities.
     */
    public void setCharacteristicDesc( @Nonnull final List<ClfnCharcDescForKeyDate> value )
    {
        if( toCharacteristicDesc == null ) {
            toCharacteristicDesc = Lists.newArrayList();
        }
        toCharacteristicDesc.clear();
        toCharacteristicDesc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnCharcDescForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_CharacteristicDesc</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicDesc</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnCharcDescForKeyDate</b> entities.
     */
    public void addCharacteristicDesc( ClfnCharcDescForKeyDate... entity )
    {
        if( toCharacteristicDesc == null ) {
            toCharacteristicDesc = Lists.newArrayList();
        }
        toCharacteristicDesc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ClfnCharcRefForKeyDate</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CharacteristicReference</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnCharcRefForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcRefForKeyDate> fetchCharacteristicReference()
    {
        return fetchFieldAsList("to_CharacteristicReference", ClfnCharcRefForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnCharcRefForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicReference</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicReference</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnCharcRefForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcRefForKeyDate> getCharacteristicReferenceOrFetch()
    {
        if( toCharacteristicReference == null ) {
            toCharacteristicReference = fetchCharacteristicReference();
        }
        return toCharacteristicReference;
    }

    /**
     * Retrieval of associated <b>ClfnCharcRefForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicReference</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnCharacteristicForKeyDate</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CharacteristicReference</b> is already loaded, the
     *         result will contain the <b>ClfnCharcRefForKeyDate</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnCharcRefForKeyDate>> getCharacteristicReferenceIfPresent()
    {
        return Option.of(toCharacteristicReference);
    }

    /**
     * Overwrites the list of associated <b>ClfnCharcRefForKeyDate</b> entities for the loaded navigation property
     * <b>to_CharacteristicReference</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicReference</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnCharcRefForKeyDate</b> entities.
     */
    public void setCharacteristicReference( @Nonnull final List<ClfnCharcRefForKeyDate> value )
    {
        if( toCharacteristicReference == null ) {
            toCharacteristicReference = Lists.newArrayList();
        }
        toCharacteristicReference.clear();
        toCharacteristicReference.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnCharcRefForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_CharacteristicReference</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicReference</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnCharcRefForKeyDate</b> entities.
     */
    public void addCharacteristicReference( ClfnCharcRefForKeyDate... entity )
    {
        if( toCharacteristicReference == null ) {
            toCharacteristicReference = Lists.newArrayList();
        }
        toCharacteristicReference.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ClfnCharcRstrcnForKeyDate</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CharacteristicRestriction</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnCharcRstrcnForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcRstrcnForKeyDate> fetchCharacteristicRestriction()
    {
        return fetchFieldAsList("to_CharacteristicRestriction", ClfnCharcRstrcnForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnCharcRstrcnForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicRestriction</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicRestriction</b> of a queried <b>ClfnCharacteristicForKeyDate</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnCharcRstrcnForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcRstrcnForKeyDate> getCharacteristicRestrictionOrFetch()
    {
        if( toCharacteristicRestriction == null ) {
            toCharacteristicRestriction = fetchCharacteristicRestriction();
        }
        return toCharacteristicRestriction;
    }

    /**
     * Retrieval of associated <b>ClfnCharcRstrcnForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicRestriction</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnCharacteristicForKeyDate</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CharacteristicRestriction</b> is already loaded, the
     *         result will contain the <b>ClfnCharcRstrcnForKeyDate</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnCharcRstrcnForKeyDate>> getCharacteristicRestrictionIfPresent()
    {
        return Option.of(toCharacteristicRestriction);
    }

    /**
     * Overwrites the list of associated <b>ClfnCharcRstrcnForKeyDate</b> entities for the loaded navigation property
     * <b>to_CharacteristicRestriction</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicRestriction</b> of a queried <b>ClfnCharacteristicForKeyDate</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnCharcRstrcnForKeyDate</b> entities.
     */
    public void setCharacteristicRestriction( @Nonnull final List<ClfnCharcRstrcnForKeyDate> value )
    {
        if( toCharacteristicRestriction == null ) {
            toCharacteristicRestriction = Lists.newArrayList();
        }
        toCharacteristicRestriction.clear();
        toCharacteristicRestriction.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnCharcRstrcnForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_CharacteristicRestriction</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicRestriction</b> of a queried <b>ClfnCharacteristicForKeyDate</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnCharcRstrcnForKeyDate</b> entities.
     */
    public void addCharacteristicRestriction( ClfnCharcRstrcnForKeyDate... entity )
    {
        if( toCharacteristicRestriction == null ) {
            toCharacteristicRestriction = Lists.newArrayList();
        }
        toCharacteristicRestriction.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ClfnCharcValueForKeyDate</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CharacteristicValue</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnCharcValueForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcValueForKeyDate> fetchCharacteristicValue()
    {
        return fetchFieldAsList("to_CharacteristicValue", ClfnCharcValueForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnCharcValueForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicValue</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicValue</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnCharcValueForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcValueForKeyDate> getCharacteristicValueOrFetch()
    {
        if( toCharacteristicValue == null ) {
            toCharacteristicValue = fetchCharacteristicValue();
        }
        return toCharacteristicValue;
    }

    /**
     * Retrieval of associated <b>ClfnCharcValueForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharacteristicValue</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnCharacteristicForKeyDate</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CharacteristicValue</b> is already loaded, the result
     *         will contain the <b>ClfnCharcValueForKeyDate</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnCharcValueForKeyDate>> getCharacteristicValueIfPresent()
    {
        return Option.of(toCharacteristicValue);
    }

    /**
     * Overwrites the list of associated <b>ClfnCharcValueForKeyDate</b> entities for the loaded navigation property
     * <b>to_CharacteristicValue</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicValue</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnCharcValueForKeyDate</b> entities.
     */
    public void setCharacteristicValue( @Nonnull final List<ClfnCharcValueForKeyDate> value )
    {
        if( toCharacteristicValue == null ) {
            toCharacteristicValue = Lists.newArrayList();
        }
        toCharacteristicValue.clear();
        toCharacteristicValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnCharcValueForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_CharacteristicValue</b>.
     * <p>
     * If the navigation property <b>to_CharacteristicValue</b> of a queried <b>ClfnCharacteristicForKeyDate</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnCharcValueForKeyDate</b> entities.
     */
    public void addCharacteristicValue( ClfnCharcValueForKeyDate... entity )
    {
        if( toCharacteristicValue == null ) {
            toCharacteristicValue = Lists.newArrayList();
        }
        toCharacteristicValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ClfnCharacteristicForKeyDate instances.
     *
     */
    public final static class ClfnCharacteristicForKeyDateBuilder
    {

        private List<ClfnCharcDescForKeyDate> toCharacteristicDesc = Lists.newArrayList();
        private List<ClfnCharcRefForKeyDate> toCharacteristicReference = Lists.newArrayList();
        private List<ClfnCharcRstrcnForKeyDate> toCharacteristicRestriction = Lists.newArrayList();
        private List<ClfnCharcValueForKeyDate> toCharacteristicValue = Lists.newArrayList();

        private ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder toCharacteristicDesc(
            final List<ClfnCharcDescForKeyDate> value )
        {
            toCharacteristicDesc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CharacteristicDesc</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
         * <b>ClfnCharcDescForKeyDate</b>.
         *
         * @param value
         *            The ClfnCharcDescForKeyDates to build this ClfnCharacteristicForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder characteristicDesc(
            ClfnCharcDescForKeyDate... value )
        {
            return toCharacteristicDesc(Lists.newArrayList(value));
        }

        private ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder toCharacteristicReference(
            final List<ClfnCharcRefForKeyDate> value )
        {
            toCharacteristicReference.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CharacteristicReference</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
         * <b>ClfnCharcRefForKeyDate</b>.
         *
         * @param value
         *            The ClfnCharcRefForKeyDates to build this ClfnCharacteristicForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder characteristicReference(
            ClfnCharcRefForKeyDate... value )
        {
            return toCharacteristicReference(Lists.newArrayList(value));
        }

        private ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder toCharacteristicRestriction(
            final List<ClfnCharcRstrcnForKeyDate> value )
        {
            toCharacteristicRestriction.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CharacteristicRestriction</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
         * <b>ClfnCharcRstrcnForKeyDate</b>.
         *
         * @param value
         *            The ClfnCharcRstrcnForKeyDates to build this ClfnCharacteristicForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder characteristicRestriction(
            ClfnCharcRstrcnForKeyDate... value )
        {
            return toCharacteristicRestriction(Lists.newArrayList(value));
        }

        private ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder toCharacteristicValue(
            final List<ClfnCharcValueForKeyDate> value )
        {
            toCharacteristicValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CharacteristicValue</b> for <b>ClfnCharacteristicForKeyDate</b> to multiple
         * <b>ClfnCharcValueForKeyDate</b>.
         *
         * @param value
         *            The ClfnCharcValueForKeyDates to build this ClfnCharacteristicForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnCharacteristicForKeyDate.ClfnCharacteristicForKeyDateBuilder characteristicValue(
            ClfnCharcValueForKeyDate... value )
        {
            return toCharacteristicValue(Lists.newArrayList(value));
        }

    }

}
