/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable.ClfnCharcRefForKeyDateSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
 * ClfnCharcRefForKeyDate} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ClfnCharcRefForKeyDateByKeyFluentHelper
    extends
    FluentHelperByKey<ClfnCharcRefForKeyDateByKeyFluentHelper, ClfnCharcRefForKeyDate, ClfnCharcRefForKeyDateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     * ClfnCharcRefForKeyDate} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ClfnCharcRefForKeyDate}
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param charcReferenceTableField
     *            Field Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ClfnCharcRefForKeyDate}
     * @param charcReferenceTable
     *            Table Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public ClfnCharcRefForKeyDateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String charcInternalID,
        final String charcReferenceTable,
        final String charcReferenceTableField )
    {
        super(servicePath, entityCollection);
        this.key.put("CharcInternalID", charcInternalID);
        this.key.put("CharcReferenceTable", charcReferenceTable);
        this.key.put("CharcReferenceTableField", charcReferenceTableField);
    }

    @Override
    @Nonnull
    protected Class<ClfnCharcRefForKeyDate> getEntityClass()
    {
        return ClfnCharcRefForKeyDate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
