/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable.ClfnCharcRstrcnForKeyDateSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
 * ClfnCharcRstrcnForKeyDate} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ClfnCharcRstrcnForKeyDateByKeyFluentHelper
    extends
    FluentHelperByKey<ClfnCharcRstrcnForKeyDateByKeyFluentHelper, ClfnCharcRstrcnForKeyDate, ClfnCharcRstrcnForKeyDateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     * ClfnCharcRstrcnForKeyDate} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ClfnCharcRstrcnForKeyDate}
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ClfnCharcRstrcnForKeyDate}
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public ClfnCharcRstrcnForKeyDateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String charcInternalID,
        final String classType )
    {
        super(servicePath, entityCollection);
        this.key.put("CharcInternalID", charcInternalID);
        this.key.put("ClassType", classType);
    }

    @Override
    @Nonnull
    protected Class<ClfnCharcRstrcnForKeyDate> getEntityClass()
    {
        return ClfnCharcRstrcnForKeyDate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
