/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.field.ClfnCharcValueForKeyDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.link.ClfnCharcValueForKeyDateLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable.ClfnCharcValueForKeyDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Characteristic Values
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ClfnCharcValueForKeyDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ClfnCharcValueForKeyDate extends VdmEntity<ClfnCharcValueForKeyDate>
{

    /**
     * Selector for all available fields of ClfnCharcValueForKeyDate.
     *
     */
    public final static ClfnCharcValueForKeyDateSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<Boolean> DELETE_MC =
        new ClfnCharcValueForKeyDateField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<Boolean> UPDATE_MC =
        new ClfnCharcValueForKeyDateField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharcValueDesc_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_CharcValueDesc_oc" )
    @JsonProperty( "to_CharcValueDesc_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_CharcValueDesc_oc" )
    private Boolean charcValueDesc_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_CharcValueDesc_oc</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<Boolean> CHARC_VALUE_DESC_OC =
        new ClfnCharcValueForKeyDateField<Boolean>("to_CharcValueDesc_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> CHARC_INTERNAL_ID =
        new ClfnCharcValueForKeyDateField<String>("CharcInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @return Int counter
     */
    @Key
    @SerializedName( "CharcValuePositionNumber" )
    @JsonProperty( "CharcValuePositionNumber" )
    @Nullable
    @ODataField( odataName = "CharcValuePositionNumber" )
    private String charcValuePositionNumber;
    /**
     * Use with available fluent helpers to apply the <b>CharcValuePositionNumber</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> CHARC_VALUE_POSITION_NUMBER =
        new ClfnCharcValueForKeyDateField<String>("CharcValuePositionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @return Code for value dependency
     */
    @SerializedName( "CharcValueDependency" )
    @JsonProperty( "CharcValueDependency" )
    @Nullable
    @ODataField( odataName = "CharcValueDependency" )
    private String charcValueDependency;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueDependency</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> CHARC_VALUE_DEPENDENCY =
        new ClfnCharcValueForKeyDateField<String>("CharcValueDependency");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @SerializedName( "CharcValue" )
    @JsonProperty( "CharcValue" )
    @Nullable
    @ODataField( odataName = "CharcValue" )
    private String charcValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcValue</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> CHARC_VALUE =
        new ClfnCharcValueForKeyDateField<String>("CharcValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @return Internal floating point from
     */
    @SerializedName( "CharcFromNumericValue" )
    @JsonProperty( "CharcFromNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValue" )
    private Double charcFromNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValue</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<Double> CHARC_FROM_NUMERIC_VALUE =
        new ClfnCharcValueForKeyDateField<Double>("CharcFromNumericValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @return Internal floating point value to
     */
    @SerializedName( "CharcToNumericValue" )
    @JsonProperty( "CharcToNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValue" )
    private Double charcToNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValue</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<Double> CHARC_TO_NUMERIC_VALUE =
        new ClfnCharcValueForKeyDateField<Double>("CharcToNumericValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDefaultValue</b>
     * </p>
     *
     * @return Default value
     */
    @SerializedName( "IsDefaultValue" )
    @JsonProperty( "IsDefaultValue" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDefaultValue" )
    private Boolean isDefaultValue;
    /**
     * Use with available fluent helpers to apply the <b>IsDefaultValue</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<Boolean> IS_DEFAULT_VALUE =
        new ClfnCharcValueForKeyDateField<Boolean>("IsDefaultValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcFromNumericValueUnit" )
    @JsonProperty( "CharcFromNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValueUnit" )
    private String charcFromNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValueUnit</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> CHARC_FROM_NUMERIC_VALUE_UNIT =
        new ClfnCharcValueForKeyDateField<String>("CharcFromNumericValueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcToNumericValueUnit" )
    @JsonProperty( "CharcToNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValueUnit" )
    private String charcToNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValueUnit</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> CHARC_TO_NUMERIC_VALUE_UNIT =
        new ClfnCharcValueForKeyDateField<String>("CharcToNumericValueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Number of Related Text
     */
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> LONG_TEXT_ID =
        new ClfnCharcValueForKeyDateField<String>("LongTextID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> CHANGE_NUMBER =
        new ClfnCharcValueForKeyDateField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DocumentType" )
    @JsonProperty( "DocumentType" )
    @Nullable
    @ODataField( odataName = "DocumentType" )
    private String documentType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentType</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> DOCUMENT_TYPE =
        new ClfnCharcValueForKeyDateField<String>("DocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @SerializedName( "DocNumber" )
    @JsonProperty( "DocNumber" )
    @Nullable
    @ODataField( odataName = "DocNumber" )
    private String docNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocNumber</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> DOC_NUMBER =
        new ClfnCharcValueForKeyDateField<String>("DocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @return Document Part
     */
    @SerializedName( "DocumentPart" )
    @JsonProperty( "DocumentPart" )
    @Nullable
    @ODataField( odataName = "DocumentPart" )
    private String documentPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentPart</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> DOCUMENT_PART =
        new ClfnCharcValueForKeyDateField<String>("DocumentPart");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @SerializedName( "DocumentVersion" )
    @JsonProperty( "DocumentVersion" )
    @Nullable
    @ODataField( odataName = "DocumentVersion" )
    private String documentVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentVersion</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<String> DOCUMENT_VERSION =
        new ClfnCharcValueForKeyDateField<String>("DocumentVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<LocalDateTime> VALIDITY_START_DATE =
        new ClfnCharcValueForKeyDateField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<LocalDateTime> VALIDITY_END_DATE =
        new ClfnCharcValueForKeyDateField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return Date data element for SYST
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<LocalDateTime> KEY_DATE =
        new ClfnCharcValueForKeyDateField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CharcLastChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CharcLastChangedDateTime" )
    @JsonProperty( "CharcLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime charcLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcLastChangedDateTime</b> field to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateField<ZonedDateTime> CHARC_LAST_CHANGED_DATE_TIME =
        new ClfnCharcValueForKeyDateField<ZonedDateTime>("CharcLastChangedDateTime");
    /**
     * Navigation property <b>to_CharcValueDesc</b> for <b>ClfnCharcValueForKeyDate</b> to multiple
     * <b>ClfnCharcValueDescForKeyDate</b>.
     *
     */
    @SerializedName( "to_CharcValueDesc" )
    @JsonProperty( "to_CharcValueDesc" )
    @ODataField( odataName = "to_CharcValueDesc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnCharcValueDescForKeyDate> toCharcValueDesc;
    /**
     * Use with available fluent helpers to apply the <b>to_CharcValueDesc</b> navigation property to query operations.
     *
     */
    public final static ClfnCharcValueForKeyDateLink<ClfnCharcValueDescForKeyDate> TO_CHARC_VALUE_DESC =
        new ClfnCharcValueForKeyDateLink<ClfnCharcValueDescForKeyDate>("to_CharcValueDesc");

    @Nonnull
    @Override
    public Class<ClfnCharcValueForKeyDate> getType()
    {
        return ClfnCharcValueForKeyDate.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_CharcValueDesc_oc</b>
     * </p>
     *
     * @param charcValueDesc_oc
     *            Dynamic CbA-Control
     */
    public void setCharcValueDesc_oc( @Nullable final Boolean charcValueDesc_oc )
    {
        rememberChangedField("to_CharcValueDesc_oc", this.charcValueDesc_oc);
        this.charcValueDesc_oc = charcValueDesc_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @param charcValuePositionNumber
     *            Int counter
     */
    public void setCharcValuePositionNumber( @Nullable final String charcValuePositionNumber )
    {
        rememberChangedField("CharcValuePositionNumber", this.charcValuePositionNumber);
        this.charcValuePositionNumber = charcValuePositionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @param charcValueDependency
     *            Code for value dependency
     */
    public void setCharcValueDependency( @Nullable final String charcValueDependency )
    {
        rememberChangedField("CharcValueDependency", this.charcValueDependency);
        this.charcValueDependency = charcValueDependency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @param charcValue
     *            Characteristic Value
     */
    public void setCharcValue( @Nullable final String charcValue )
    {
        rememberChangedField("CharcValue", this.charcValue);
        this.charcValue = charcValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @param charcFromNumericValue
     *            Internal floating point from
     */
    public void setCharcFromNumericValue( @Nullable final Double charcFromNumericValue )
    {
        rememberChangedField("CharcFromNumericValue", this.charcFromNumericValue);
        this.charcFromNumericValue = charcFromNumericValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @param charcToNumericValue
     *            Internal floating point value to
     */
    public void setCharcToNumericValue( @Nullable final Double charcToNumericValue )
    {
        rememberChangedField("CharcToNumericValue", this.charcToNumericValue);
        this.charcToNumericValue = charcToNumericValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDefaultValue</b>
     * </p>
     *
     * @param isDefaultValue
     *            Default value
     */
    public void setIsDefaultValue( @Nullable final Boolean isDefaultValue )
    {
        rememberChangedField("IsDefaultValue", this.isDefaultValue);
        this.isDefaultValue = isDefaultValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @param charcFromNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcFromNumericValueUnit( @Nullable final String charcFromNumericValueUnit )
    {
        rememberChangedField("CharcFromNumericValueUnit", this.charcFromNumericValueUnit);
        this.charcFromNumericValueUnit = charcFromNumericValueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @param charcToNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcToNumericValueUnit( @Nullable final String charcToNumericValueUnit )
    {
        rememberChangedField("CharcToNumericValueUnit", this.charcToNumericValueUnit);
        this.charcToNumericValueUnit = charcToNumericValueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Number of Related Text
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *            Document Type
     */
    public void setDocumentType( @Nullable final String documentType )
    {
        rememberChangedField("DocumentType", this.documentType);
        this.documentType = documentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @param docNumber
     *            Document number
     */
    public void setDocNumber( @Nullable final String docNumber )
    {
        rememberChangedField("DocNumber", this.docNumber);
        this.docNumber = docNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *            Document Part
     */
    public void setDocumentPart( @Nullable final String documentPart )
    {
        rememberChangedField("DocumentPart", this.documentPart);
        this.documentPart = documentPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *            Document Version
     */
    public void setDocumentVersion( @Nullable final String documentVersion )
    {
        rememberChangedField("DocumentVersion", this.documentVersion);
        this.documentVersion = documentVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            Date data element for SYST
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CharcLastChangedDateTime</b>
     * </p>
     *
     * @param charcLastChangedDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCharcLastChangedDateTime( @Nullable final ZonedDateTime charcLastChangedDateTime )
    {
        rememberChangedField("CharcLastChangedDateTime", this.charcLastChangedDateTime);
        this.charcLastChangedDateTime = charcLastChangedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ClfnCharcValueForKeyDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CharcInternalID", getCharcInternalID());
        result.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_CharcValueDesc_oc", getCharcValueDesc_oc());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        values.put("CharcValueDependency", getCharcValueDependency());
        values.put("CharcValue", getCharcValue());
        values.put("CharcFromNumericValue", getCharcFromNumericValue());
        values.put("CharcToNumericValue", getCharcToNumericValue());
        values.put("IsDefaultValue", getIsDefaultValue());
        values.put("CharcFromNumericValueUnit", getCharcFromNumericValueUnit());
        values.put("CharcToNumericValueUnit", getCharcToNumericValueUnit());
        values.put("LongTextID", getLongTextID());
        values.put("ChangeNumber", getChangeNumber());
        values.put("DocumentType", getDocumentType());
        values.put("DocNumber", getDocNumber());
        values.put("DocumentPart", getDocumentPart());
        values.put("DocumentVersion", getDocumentVersion());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("KeyDate", getKeyDate());
        values.put("CharcLastChangedDateTime", getCharcLastChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_CharcValueDesc_oc") ) {
                final Object value = values.remove("to_CharcValueDesc_oc");
                if( (value == null) || (!value.equals(getCharcValueDesc_oc())) ) {
                    setCharcValueDesc_oc(((Boolean) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcValuePositionNumber") ) {
                final Object value = values.remove("CharcValuePositionNumber");
                if( (value == null) || (!value.equals(getCharcValuePositionNumber())) ) {
                    setCharcValuePositionNumber(((String) value));
                }
            }
            if( values.containsKey("CharcValueDependency") ) {
                final Object value = values.remove("CharcValueDependency");
                if( (value == null) || (!value.equals(getCharcValueDependency())) ) {
                    setCharcValueDependency(((String) value));
                }
            }
            if( values.containsKey("CharcValue") ) {
                final Object value = values.remove("CharcValue");
                if( (value == null) || (!value.equals(getCharcValue())) ) {
                    setCharcValue(((String) value));
                }
            }
            if( values.containsKey("CharcFromNumericValue") ) {
                final Object value = values.remove("CharcFromNumericValue");
                if( (value == null) || (!value.equals(getCharcFromNumericValue())) ) {
                    setCharcFromNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcToNumericValue") ) {
                final Object value = values.remove("CharcToNumericValue");
                if( (value == null) || (!value.equals(getCharcToNumericValue())) ) {
                    setCharcToNumericValue(((Double) value));
                }
            }
            if( values.containsKey("IsDefaultValue") ) {
                final Object value = values.remove("IsDefaultValue");
                if( (value == null) || (!value.equals(getIsDefaultValue())) ) {
                    setIsDefaultValue(((Boolean) value));
                }
            }
            if( values.containsKey("CharcFromNumericValueUnit") ) {
                final Object value = values.remove("CharcFromNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcFromNumericValueUnit())) ) {
                    setCharcFromNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcToNumericValueUnit") ) {
                final Object value = values.remove("CharcToNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcToNumericValueUnit())) ) {
                    setCharcToNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentType") ) {
                final Object value = values.remove("DocumentType");
                if( (value == null) || (!value.equals(getDocumentType())) ) {
                    setDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocNumber") ) {
                final Object value = values.remove("DocNumber");
                if( (value == null) || (!value.equals(getDocNumber())) ) {
                    setDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentPart") ) {
                final Object value = values.remove("DocumentPart");
                if( (value == null) || (!value.equals(getDocumentPart())) ) {
                    setDocumentPart(((String) value));
                }
            }
            if( values.containsKey("DocumentVersion") ) {
                final Object value = values.remove("DocumentVersion");
                if( (value == null) || (!value.equals(getDocumentVersion())) ) {
                    setDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcLastChangedDateTime") ) {
                final Object value = values.remove("CharcLastChangedDateTime");
                if( (value == null) || (!value.equals(getCharcLastChangedDateTime())) ) {
                    setCharcLastChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CharcValueDesc") ) {
                final Object value = (values).remove("to_CharcValueDesc");
                if( value instanceof Iterable ) {
                    if( toCharcValueDesc == null ) {
                        toCharcValueDesc = Lists.newArrayList();
                    } else {
                        toCharcValueDesc = Lists.newArrayList(toCharcValueDesc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnCharcValueDescForKeyDate entity;
                        if( toCharcValueDesc.size() > i ) {
                            entity = toCharcValueDesc.get(i);
                        } else {
                            entity = new ClfnCharcValueDescForKeyDate();
                            toCharcValueDesc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ClfnCharcValueForKeyDateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ClfnCharcValueForKeyDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ClfnCharcValueForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ClfnCharcValueForKeyDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCharcValueDesc != null ) {
            (values).put("to_CharcValueDesc", toCharcValueDesc);
        }
        return values;
    }

    /**
     * Fetches the <b>ClfnCharcValueDescForKeyDate</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CharcValueDesc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnCharcValueDescForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcValueDescForKeyDate> fetchCharcValueDesc()
    {
        return fetchFieldAsList("to_CharcValueDesc", ClfnCharcValueDescForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnCharcValueDescForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharcValueDesc</b>.
     * <p>
     * If the navigation property <b>to_CharcValueDesc</b> of a queried <b>ClfnCharcValueForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnCharcValueDescForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnCharcValueDescForKeyDate> getCharcValueDescOrFetch()
    {
        if( toCharcValueDesc == null ) {
            toCharcValueDesc = fetchCharcValueDesc();
        }
        return toCharcValueDesc;
    }

    /**
     * Retrieval of associated <b>ClfnCharcValueDescForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CharcValueDesc</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnCharcValueForKeyDate</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CharcValueDesc</b> is already loaded, the result will
     *         contain the <b>ClfnCharcValueDescForKeyDate</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnCharcValueDescForKeyDate>> getCharcValueDescIfPresent()
    {
        return Option.of(toCharcValueDesc);
    }

    /**
     * Overwrites the list of associated <b>ClfnCharcValueDescForKeyDate</b> entities for the loaded navigation property
     * <b>to_CharcValueDesc</b>.
     * <p>
     * If the navigation property <b>to_CharcValueDesc</b> of a queried <b>ClfnCharcValueForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnCharcValueDescForKeyDate</b> entities.
     */
    public void setCharcValueDesc( @Nonnull final List<ClfnCharcValueDescForKeyDate> value )
    {
        if( toCharcValueDesc == null ) {
            toCharcValueDesc = Lists.newArrayList();
        }
        toCharcValueDesc.clear();
        toCharcValueDesc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnCharcValueDescForKeyDate</b> entities. This corresponds to the
     * OData navigation property <b>to_CharcValueDesc</b>.
     * <p>
     * If the navigation property <b>to_CharcValueDesc</b> of a queried <b>ClfnCharcValueForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnCharcValueDescForKeyDate</b> entities.
     */
    public void addCharcValueDesc( ClfnCharcValueDescForKeyDate... entity )
    {
        if( toCharcValueDesc == null ) {
            toCharcValueDesc = Lists.newArrayList();
        }
        toCharcValueDesc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ClfnCharcValueForKeyDate instances.
     *
     */
    public final static class ClfnCharcValueForKeyDateBuilder
    {

        private List<ClfnCharcValueDescForKeyDate> toCharcValueDesc = Lists.newArrayList();

        private ClfnCharcValueForKeyDate.ClfnCharcValueForKeyDateBuilder toCharcValueDesc(
            final List<ClfnCharcValueDescForKeyDate> value )
        {
            toCharcValueDesc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CharcValueDesc</b> for <b>ClfnCharcValueForKeyDate</b> to multiple
         * <b>ClfnCharcValueDescForKeyDate</b>.
         *
         * @param value
         *            The ClfnCharcValueDescForKeyDates to build this ClfnCharcValueForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnCharcValueForKeyDate.ClfnCharcValueForKeyDateBuilder charcValueDesc(
            ClfnCharcValueDescForKeyDate... value )
        {
            return toCharcValueDesc(Lists.newArrayList(value));
        }

    }

}
