/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService
 * CharacteristicDataForClassificationService}.
 *
 */
public interface CharacteristicDataForClassificationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CharacteristicDataForClassificationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CharacteristicDataForClassificationServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharacteristicForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *            ClfnCharacteristicForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        createClfnCharacteristicForKeyDate( @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharacteristicForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *            ClfnCharacteristicForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        updateClfnCharacteristicForKeyDate( @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharacteristicForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *            ClfnCharacteristicForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        deleteClfnCharacteristicForKeyDate( @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *            ClfnCharcDescForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        createClfnCharcDescForKeyDate( @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *            ClfnCharcDescForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        updateClfnCharcDescForKeyDate( @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *            ClfnCharcDescForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        deleteClfnCharcDescForKeyDate( @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     * ClfnCharcRefForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcRefForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *            ClfnCharcRefForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        createClfnCharcRefForKeyDate( @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     * ClfnCharcRefForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcRefForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *            ClfnCharcRefForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        deleteClfnCharcRefForKeyDate( @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     * ClfnCharcRstrcnForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcRstrcnForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *            ClfnCharcRstrcnForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        createClfnCharcRstrcnForKeyDate( @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     * ClfnCharcRstrcnForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcRstrcnForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *            ClfnCharcRstrcnForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        deleteClfnCharcRstrcnForKeyDate( @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *            ClfnCharcValueDescForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        createClfnCharcValueDescForKeyDate( @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *            ClfnCharcValueDescForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        updateClfnCharcValueDescForKeyDate( @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcValueDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *            ClfnCharcValueDescForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        deleteClfnCharcValueDescForKeyDate( @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *            ClfnCharcValueForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        createClfnCharcValueForKeyDate( @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *            ClfnCharcValueForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        updateClfnCharcValueForKeyDate( @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcValueForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *            ClfnCharcValueForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CharacteristicDataForClassificationServiceBatchChangeSet
        deleteClfnCharcValueForKeyDate( @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate );

}
