/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CharacteristicDataForClassificationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService
 * CharacteristicDataForClassificationService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultCharacteristicDataForClassificationServiceBatch
    extends
    BatchFluentHelperBasic<CharacteristicDataForClassificationServiceBatch, CharacteristicDataForClassificationServiceBatchChangeSet>
    implements
    CharacteristicDataForClassificationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCharacteristicDataForClassificationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCharacteristicDataForClassificationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCharacteristicDataForClassificationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCharacteristicDataForClassificationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCharacteristicDataForClassificationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCharacteristicDataForClassificationServiceBatchChangeSet(this, service);
    }

}
