/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate;

/**
 * Implementation of the {@link CharacteristicDataForClassificationServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService
 * CharacteristicDataForClassificationService}.
 *
 */
public class DefaultCharacteristicDataForClassificationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CharacteristicDataForClassificationServiceBatch, CharacteristicDataForClassificationServiceBatchChangeSet>
    implements
    CharacteristicDataForClassificationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService service;

    @SuppressWarnings( "deprecation" )
    DefaultCharacteristicDataForClassificationServiceBatchChangeSet(
        @Nonnull final DefaultCharacteristicDataForClassificationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CharacteristicDataForClassificationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCharacteristicDataForClassificationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet createClfnCharacteristicForKeyDate(
        @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate )
    {
        return addRequestCreate(service::createClfnCharacteristicForKeyDate, clfnCharacteristicForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet updateClfnCharacteristicForKeyDate(
        @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate )
    {
        return addRequestUpdate(service::updateClfnCharacteristicForKeyDate, clfnCharacteristicForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet deleteClfnCharacteristicForKeyDate(
        @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate )
    {
        return addRequestDelete(service::deleteClfnCharacteristicForKeyDate, clfnCharacteristicForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet createClfnCharcDescForKeyDate(
        @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate )
    {
        return addRequestCreate(service::createClfnCharcDescForKeyDate, clfnCharcDescForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet updateClfnCharcDescForKeyDate(
        @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate )
    {
        return addRequestUpdate(service::updateClfnCharcDescForKeyDate, clfnCharcDescForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet deleteClfnCharcDescForKeyDate(
        @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate )
    {
        return addRequestDelete(service::deleteClfnCharcDescForKeyDate, clfnCharcDescForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet createClfnCharcRefForKeyDate(
        @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate )
    {
        return addRequestCreate(service::createClfnCharcRefForKeyDate, clfnCharcRefForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet deleteClfnCharcRefForKeyDate(
        @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate )
    {
        return addRequestDelete(service::deleteClfnCharcRefForKeyDate, clfnCharcRefForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet createClfnCharcRstrcnForKeyDate(
        @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate )
    {
        return addRequestCreate(service::createClfnCharcRstrcnForKeyDate, clfnCharcRstrcnForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet deleteClfnCharcRstrcnForKeyDate(
        @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate )
    {
        return addRequestDelete(service::deleteClfnCharcRstrcnForKeyDate, clfnCharcRstrcnForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet createClfnCharcValueDescForKeyDate(
        @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate )
    {
        return addRequestCreate(service::createClfnCharcValueDescForKeyDate, clfnCharcValueDescForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet updateClfnCharcValueDescForKeyDate(
        @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate )
    {
        return addRequestUpdate(service::updateClfnCharcValueDescForKeyDate, clfnCharcValueDescForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet deleteClfnCharcValueDescForKeyDate(
        @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate )
    {
        return addRequestDelete(service::deleteClfnCharcValueDescForKeyDate, clfnCharcValueDescForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet createClfnCharcValueForKeyDate(
        @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate )
    {
        return addRequestCreate(service::createClfnCharcValueForKeyDate, clfnCharcValueForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet updateClfnCharcValueForKeyDate(
        @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate )
    {
        return addRequestUpdate(service::updateClfnCharcValueForKeyDate, clfnCharcValueForKeyDate);
    }

    @Nonnull
    @Override
    public CharacteristicDataForClassificationServiceBatchChangeSet deleteClfnCharcValueForKeyDate(
        @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate )
    {
        return addRequestDelete(service::deleteClfnCharcValueForKeyDate, clfnCharcValueForKeyDate);
    }

}
