/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable.ClfnCharcRefForKeyDateSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
 * ClfnCharcRefForKeyDate} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ClfnCharcRefForKeyDateLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ClfnCharcRefForKeyDateLink<ObjectT>, ClfnCharcRefForKeyDate, ObjectT>
    implements
    ClfnCharcRefForKeyDateSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ClfnCharcRefForKeyDateLink( final String fieldName )
    {
        super(fieldName);
    }

    private ClfnCharcRefForKeyDateLink(
        final EntityLink<ClfnCharcRefForKeyDateLink<ObjectT>, ClfnCharcRefForKeyDate, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ClfnCharcRefForKeyDateLink<ObjectT> translateLinkType(
        final EntityLink<ClfnCharcRefForKeyDateLink<ObjectT>, ClfnCharcRefForKeyDate, ObjectT> link )
    {
        return new ClfnCharcRefForKeyDateLink<ObjectT>(link);
    }

}
