/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
 * ClfnCharacteristicForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.field.ClfnCharacteristicForKeyDateField
 * ClfnCharacteristicForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.link.ClfnCharacteristicForKeyDateLink
 * ClfnCharacteristicForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARACTERISTIC_DESC_OC
 * CHARACTERISTIC_DESC_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARACTERISTIC_REFERENCE_OC
 * CHARACTERISTIC_REFERENCE_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARACTERISTIC_RESTRICTION_OC
 * CHARACTERISTIC_RESTRICTION_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARACTERISTIC_VALUE_OC
 * CHARACTERISTIC_VALUE_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARACTERISTIC
 * CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_STATUS
 * CHARC_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_STATUS_NAME
 * CHARC_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_DATA_TYPE
 * CHARC_DATA_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_LENGTH
 * CHARC_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_DECIMALS
 * CHARC_DECIMALS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_TEMPLATE
 * CHARC_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#VALUE_IS_CASE_SENSITIVE
 * VALUE_IS_CASE_SENSITIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_GROUP
 * CHARC_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_GROUP_NAME
 * CHARC_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#ENTRY_IS_REQUIRED
 * ENTRY_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#MULTIPLE_VALUES_ARE_ALLOWED
 * MULTIPLE_VALUES_ARE_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_VALUE_UNIT
 * CHARC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#UNIT_OF_MEASURE_ISO_CODE
 * UNIT_OF_MEASURE_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CURRENCY_ISO_CODE
 * CURRENCY_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_EXPONENT_VALUE
 * CHARC_EXPONENT_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#VALUE_INTERVAL_IS_ALLOWED
 * VALUE_INTERVAL_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#ADDITIONAL_VALUE_IS_ALLOWED
 * ADDITIONAL_VALUE_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#NEGATIVE_VALUE_IS_ALLOWED
 * NEGATIVE_VALUE_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#DOCUMENT_TYPE
 * DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#DOC_NUMBER
 * DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#DOCUMENT_VERSION
 * DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#DOCUMENT_PART
 * DOCUMENT_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_MAINT_AUTH_GRP
 * CHARC_MAINT_AUTH_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_IS_READ_ONLY
 * CHARC_IS_READ_ONLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_IS_HIDDEN
 * CHARC_IS_HIDDEN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_IS_RESTRICTABLE
 * CHARC_IS_RESTRICTABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_EXPONENT_FORMAT
 * CHARC_EXPONENT_FORMAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_ENTRY_IS_NOT_FORMAT_CTRLD
 * CHARC_ENTRY_IS_NOT_FORMAT_CTRLD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_TEMPLATE_IS_DISPLAYED
 * CHARC_TEMPLATE_IS_DISPLAYED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#CHARC_LAST_CHANGED_DATE_TIME
 * CHARC_LAST_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#TO_CHARACTERISTIC_DESC
 * TO_CHARACTERISTIC_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#TO_CHARACTERISTIC_REFERENCE
 * TO_CHARACTERISTIC_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#TO_CHARACTERISTIC_RESTRICTION
 * TO_CHARACTERISTIC_RESTRICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate#TO_CHARACTERISTIC_VALUE
 * TO_CHARACTERISTIC_VALUE}</li>
 * </ul>
 *
 */
public interface ClfnCharacteristicForKeyDateSelectable extends EntitySelectable<ClfnCharacteristicForKeyDate>
{

}
