/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
 * ClfnCharcRstrcnForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.field.ClfnCharcRstrcnForKeyDateField
 * ClfnCharcRstrcnForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.link.ClfnCharcRstrcnForKeyDateLink
 * ClfnCharcRstrcnForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate#CHARC_LAST_CHANGED_DATE_TIME
 * CHARC_LAST_CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ClfnCharcRstrcnForKeyDateSelectable extends EntitySelectable<ClfnCharcRstrcnForKeyDate>
{

}
