/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
 * ClfnCharcValueDescForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.field.ClfnCharcValueDescForKeyDateField
 * ClfnCharcValueDescForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.link.ClfnCharcValueDescForKeyDateLink
 * ClfnCharcValueDescForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#CHARC_VALUE_POSITION_NUMBER
 * CHARC_VALUE_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#CHARC_VALUE_DESCRIPTION
 * CHARC_VALUE_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate#CHARC_LAST_CHANGED_DATE_TIME
 * CHARC_LAST_CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ClfnCharcValueDescForKeyDateSelectable extends EntitySelectable<ClfnCharcValueDescForKeyDate>
{

}
