/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
 * ClfnCharcValueForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.field.ClfnCharcValueForKeyDateField
 * ClfnCharcValueForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.link.ClfnCharcValueForKeyDateLink
 * ClfnCharcValueForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_VALUE_DESC_OC
 * CHARC_VALUE_DESC_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_VALUE_POSITION_NUMBER
 * CHARC_VALUE_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_VALUE_DEPENDENCY
 * CHARC_VALUE_DEPENDENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_VALUE
 * CHARC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_FROM_NUMERIC_VALUE
 * CHARC_FROM_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_TO_NUMERIC_VALUE
 * CHARC_TO_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#IS_DEFAULT_VALUE
 * IS_DEFAULT_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_FROM_NUMERIC_VALUE_UNIT
 * CHARC_FROM_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_TO_NUMERIC_VALUE_UNIT
 * CHARC_TO_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#DOCUMENT_TYPE
 * DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#DOC_NUMBER
 * DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#DOCUMENT_PART
 * DOCUMENT_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#DOCUMENT_VERSION
 * DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#CHARC_LAST_CHANGED_DATE_TIME
 * CHARC_LAST_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate#TO_CHARC_VALUE_DESC
 * TO_CHARC_VALUE_DESC}</li>
 * </ul>
 *
 */
public interface ClfnCharcValueForKeyDateSelectable extends EntitySelectable<ClfnCharcValueForKeyDate>
{

}
