/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.field.ChartOfAccountsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.link.ChartOfAccountsLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.selectable.ChartOfAccountsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Chart of Accounts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChartOfAccountsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChartOfAccounts extends VdmEntity<ChartOfAccounts>
{

    /**
     * Selector for all available fields of ChartOfAccounts.
     *
     */
    public final static ChartOfAccountsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static ChartOfAccountsField<String> CHART_OF_ACCOUNTS =
        new ChartOfAccountsField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @return Group Chart of Accts
     */
    @SerializedName( "CorporateGroupChartOfAccounts" )
    @JsonProperty( "CorporateGroupChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CorporateGroupChartOfAccounts" )
    private String corporateGroupChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupChartOfAccounts</b> field to query operations.
     *
     */
    public final static ChartOfAccountsField<String> CORPORATE_GROUP_CHART_OF_ACCOUNTS =
        new ChartOfAccountsField<String>("CorporateGroupChartOfAccounts");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAcctsIsBlocked</b>
     * </p>
     *
     * @return Indicator: is the chart of accounts blocked ?
     */
    @SerializedName( "ChartOfAcctsIsBlocked" )
    @JsonProperty( "ChartOfAcctsIsBlocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChartOfAcctsIsBlocked" )
    private Boolean chartOfAcctsIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAcctsIsBlocked</b> field to query operations.
     *
     */
    public final static ChartOfAccountsField<Boolean> CHART_OF_ACCTS_IS_BLOCKED =
        new ChartOfAccountsField<Boolean>("ChartOfAcctsIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceLanguage</b>
     * </p>
     *
     * @return Maintenance language for the chart of accounts
     */
    @SerializedName( "MaintenanceLanguage" )
    @JsonProperty( "MaintenanceLanguage" )
    @Nullable
    @ODataField( odataName = "MaintenanceLanguage" )
    private String maintenanceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceLanguage</b> field to query operations.
     *
     */
    public final static ChartOfAccountsField<String> MAINTENANCE_LANGUAGE =
        new ChartOfAccountsField<String>("MaintenanceLanguage");
    /**
     * Navigation property <b>to_Text</b> for <b>ChartOfAccounts</b> to multiple <b>ChartOfAccountsText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChartOfAccountsText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ChartOfAccountsLink<ChartOfAccountsText> TO_TEXT =
        new ChartOfAccountsLink<ChartOfAccountsText>("to_Text");

    @Nonnull
    @Override
    public Class<ChartOfAccounts> getType()
    {
        return ChartOfAccounts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @param corporateGroupChartOfAccounts
     *            Group Chart of Accts
     */
    public void setCorporateGroupChartOfAccounts( @Nullable final String corporateGroupChartOfAccounts )
    {
        rememberChangedField("CorporateGroupChartOfAccounts", this.corporateGroupChartOfAccounts);
        this.corporateGroupChartOfAccounts = corporateGroupChartOfAccounts;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAcctsIsBlocked</b>
     * </p>
     *
     * @param chartOfAcctsIsBlocked
     *            Indicator: is the chart of accounts blocked ?
     */
    public void setChartOfAcctsIsBlocked( @Nullable final Boolean chartOfAcctsIsBlocked )
    {
        rememberChangedField("ChartOfAcctsIsBlocked", this.chartOfAcctsIsBlocked);
        this.chartOfAcctsIsBlocked = chartOfAcctsIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceLanguage</b>
     * </p>
     *
     * @param maintenanceLanguage
     *            Maintenance language for the chart of accounts
     */
    public void setMaintenanceLanguage( @Nullable final String maintenanceLanguage )
    {
        rememberChangedField("MaintenanceLanguage", this.maintenanceLanguage);
        this.maintenanceLanguage = maintenanceLanguage;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChartOfAccounts";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChartOfAccounts", getChartOfAccounts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("CorporateGroupChartOfAccounts", getCorporateGroupChartOfAccounts());
        values.put("ChartOfAcctsIsBlocked", getChartOfAcctsIsBlocked());
        values.put("MaintenanceLanguage", getMaintenanceLanguage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupChartOfAccounts") ) {
                final Object value = values.remove("CorporateGroupChartOfAccounts");
                if( (value == null) || (!value.equals(getCorporateGroupChartOfAccounts())) ) {
                    setCorporateGroupChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ChartOfAcctsIsBlocked") ) {
                final Object value = values.remove("ChartOfAcctsIsBlocked");
                if( (value == null) || (!value.equals(getChartOfAcctsIsBlocked())) ) {
                    setChartOfAcctsIsBlocked(((Boolean) value));
                }
            }
            if( values.containsKey("MaintenanceLanguage") ) {
                final Object value = values.remove("MaintenanceLanguage");
                if( (value == null) || (!value.equals(getMaintenanceLanguage())) ) {
                    setMaintenanceLanguage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChartOfAccountsText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ChartOfAccountsText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChartOfAccountsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChartOfAccountsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChartOfAccountsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChartOfAccountsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>ChartOfAccountsText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChartOfAccountsText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChartOfAccountsText> fetchText()
    {
        return fetchFieldAsList("to_Text", ChartOfAccountsText.class);
    }

    /**
     * Retrieval of associated <b>ChartOfAccountsText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ChartOfAccounts</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChartOfAccountsText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChartOfAccountsText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ChartOfAccountsText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ChartOfAccounts</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ChartOfAccountsText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ChartOfAccountsText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ChartOfAccountsText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ChartOfAccounts</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChartOfAccountsText</b> entities.
     */
    public void setText( @Nonnull final List<ChartOfAccountsText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChartOfAccountsText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ChartOfAccounts</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChartOfAccountsText</b> entities.
     */
    public void addText( ChartOfAccountsText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ChartOfAccounts instances.
     *
     */
    public final static class ChartOfAccountsBuilder
    {

        private List<ChartOfAccountsText> toText = Lists.newArrayList();

        private ChartOfAccounts.ChartOfAccountsBuilder toText( final List<ChartOfAccountsText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ChartOfAccounts</b> to multiple <b>ChartOfAccountsText</b>.
         *
         * @param value
         *            The ChartOfAccountsTexts to build this ChartOfAccounts with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChartOfAccounts.ChartOfAccountsBuilder text( ChartOfAccountsText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
