/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.field.ChartOfAccountsTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.link.ChartOfAccountsTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.selectable.ChartOfAccountsTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Chart of Accounts Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChartOfAccountsTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChartOfAccountsText extends VdmEntity<ChartOfAccountsText>
{

    /**
     * Selector for all available fields of ChartOfAccountsText.
     *
     */
    public final static ChartOfAccountsTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static ChartOfAccountsTextField<String> CHART_OF_ACCOUNTS =
        new ChartOfAccountsTextField<String>("ChartOfAccounts");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ChartOfAccountsTextField<String> LANGUAGE = new ChartOfAccountsTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccountsName</b>
     * </p>
     *
     * @return Chart of accounts description
     */
    @SerializedName( "ChartOfAccountsName" )
    @JsonProperty( "ChartOfAccountsName" )
    @Nullable
    @ODataField( odataName = "ChartOfAccountsName" )
    private String chartOfAccountsName;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccountsName</b> field to query operations.
     *
     */
    public final static ChartOfAccountsTextField<String> CHART_OF_ACCOUNTS_NAME =
        new ChartOfAccountsTextField<String>("ChartOfAccountsName");
    /**
     * Navigation property <b>to_ChartOfAccounts</b> for <b>ChartOfAccountsText</b> to single <b>ChartOfAccounts</b>.
     *
     */
    @SerializedName( "to_ChartOfAccounts" )
    @JsonProperty( "to_ChartOfAccounts" )
    @ODataField( odataName = "to_ChartOfAccounts" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ChartOfAccounts toChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>to_ChartOfAccounts</b> navigation property to query operations.
     *
     */
    public final static ChartOfAccountsTextOneToOneLink<ChartOfAccounts> TO_CHART_OF_ACCOUNTS =
        new ChartOfAccountsTextOneToOneLink<ChartOfAccounts>("to_ChartOfAccounts");

    @Nonnull
    @Override
    public Class<ChartOfAccountsText> getType()
    {
        return ChartOfAccountsText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccountsName</b>
     * </p>
     *
     * @param chartOfAccountsName
     *            Chart of accounts description
     */
    public void setChartOfAccountsName( @Nullable final String chartOfAccountsName )
    {
        rememberChangedField("ChartOfAccountsName", this.chartOfAccountsName);
        this.chartOfAccountsName = chartOfAccountsName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChartOfAccountsText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChartOfAccounts", getChartOfAccounts());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("Language", getLanguage());
        values.put("ChartOfAccountsName", getChartOfAccountsName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccountsName") ) {
                final Object value = values.remove("ChartOfAccountsName");
                if( (value == null) || (!value.equals(getChartOfAccountsName())) ) {
                    setChartOfAccountsName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ChartOfAccounts") ) {
                final Object value = (values).remove("to_ChartOfAccounts");
                if( value instanceof Map ) {
                    if( toChartOfAccounts == null ) {
                        toChartOfAccounts = new ChartOfAccounts();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toChartOfAccounts.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChartOfAccountsTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChartOfAccountsTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChartOfAccountsTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChartOfAccountsTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toChartOfAccounts != null ) {
            (values).put("to_ChartOfAccounts", toChartOfAccounts);
        }
        return values;
    }

    /**
     * Fetches the <b>ChartOfAccounts</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ChartOfAccounts</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ChartOfAccounts</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ChartOfAccounts fetchChartOfAccounts()
    {
        return fetchFieldAsSingle("to_ChartOfAccounts", ChartOfAccounts.class);
    }

    /**
     * Retrieval of associated <b>ChartOfAccounts</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ChartOfAccounts</b>.
     * <p>
     * If the navigation property <b>to_ChartOfAccounts</b> of a queried <b>ChartOfAccountsText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChartOfAccounts</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ChartOfAccounts getChartOfAccountsOrFetch()
    {
        if( toChartOfAccounts == null ) {
            toChartOfAccounts = fetchChartOfAccounts();
        }
        return toChartOfAccounts;
    }

    /**
     * Retrieval of associated <b>ChartOfAccounts</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ChartOfAccounts</b>.
     * <p>
     * If the navigation property for an entity <b>ChartOfAccountsText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChartOfAccounts</b> is already loaded, the result will
     *         contain the <b>ChartOfAccounts</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ChartOfAccounts> getChartOfAccountsIfPresent()
    {
        return Option.of(toChartOfAccounts);
    }

    /**
     * Overwrites the associated <b>ChartOfAccounts</b> entity for the loaded navigation property
     * <b>to_ChartOfAccounts</b>.
     *
     * @param value
     *            New <b>ChartOfAccounts</b> entity.
     */
    public void setChartOfAccounts( final ChartOfAccounts value )
    {
        toChartOfAccounts = value;
    }

    /**
     * Helper class to allow for fluent creation of ChartOfAccountsText instances.
     *
     */
    public final static class ChartOfAccountsTextBuilder
    {

        private ChartOfAccounts toChartOfAccounts;
        private String chartOfAccounts = null;

        private ChartOfAccountsText.ChartOfAccountsTextBuilder toChartOfAccounts( final ChartOfAccounts value )
        {
            toChartOfAccounts = value;
            return this;
        }

        /**
         * Navigation property <b>to_ChartOfAccounts</b> for <b>ChartOfAccountsText</b> to single
         * <b>ChartOfAccounts</b>.
         *
         * @param value
         *            The ChartOfAccounts to build this ChartOfAccountsText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChartOfAccountsText.ChartOfAccountsTextBuilder chartOfAccounts( final ChartOfAccounts value )
        {
            return toChartOfAccounts(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
         * </p>
         *
         * @param value
         *            The chartOfAccounts to build this ChartOfAccountsText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChartOfAccountsText.ChartOfAccountsTextBuilder chartOfAccounts( final String value )
        {
            chartOfAccounts = value;
            return this;
        }

    }

}
