/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.selectable.ChartOfAccountsTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText ChartOfAccountsText}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ChartOfAccountsTextByKeyFluentHelper
    extends
    FluentHelperByKey<ChartOfAccountsTextByKeyFluentHelper, ChartOfAccountsText, ChartOfAccountsTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText
     * ChartOfAccountsText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ChartOfAccountsText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ChartOfAccountsText}
     * @param chartOfAccounts
     *            Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public ChartOfAccountsTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String chartOfAccounts,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("ChartOfAccounts", chartOfAccounts);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<ChartOfAccountsText> getEntityClass()
    {
        return ChartOfAccountsText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
