/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ChartOfAccountsServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService ChartOfAccountsService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultChartOfAccountsServiceBatch
    extends
    BatchFluentHelperBasic<ChartOfAccountsServiceBatch, ChartOfAccountsServiceBatchChangeSet>
    implements
    ChartOfAccountsServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultChartOfAccountsServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultChartOfAccountsServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultChartOfAccountsServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultChartOfAccountsServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultChartOfAccountsServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ChartOfAccountsServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultChartOfAccountsServiceBatchChangeSet(this, service);
    }

}
