/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ChartOfAccountsServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService ChartOfAccountsService}.
 *
 */
public class DefaultChartOfAccountsServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ChartOfAccountsServiceBatch, ChartOfAccountsServiceBatchChangeSet>
    implements
    ChartOfAccountsServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService service;

    @SuppressWarnings( "deprecation" )
    DefaultChartOfAccountsServiceBatchChangeSet(
        @Nonnull final DefaultChartOfAccountsServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChartOfAccountsService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultChartOfAccountsServiceBatchChangeSet getThis()
    {
        return this;
    }

}
