/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccounts;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccounts ChartOfAccounts}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.field.ChartOfAccountsField
 * ChartOfAccountsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.link.ChartOfAccountsLink
 * ChartOfAccountsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccounts#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccounts#CORPORATE_GROUP_CHART_OF_ACCOUNTS
 * CORPORATE_GROUP_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccounts#CHART_OF_ACCTS_IS_BLOCKED
 * CHART_OF_ACCTS_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccounts#MAINTENANCE_LANGUAGE
 * MAINTENANCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccounts#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface ChartOfAccountsSelectable extends EntitySelectable<ChartOfAccounts>
{

}
